/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.web.dialog.changepassword;

import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.web.dialog.changepassword.CConstants;
import de.sillysky.nyssr.json.CUtilJson;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.remoteskin.web.dialog.records.CRecordWebDismissDialog;
import de.sillysky.nyssr.remoteskin.web.protocol.CWebApi;
import de.sillysky.nyssr.remoteskin.web.protocol.CWebDialogApi;
import de.sillysky.nyssr.remoteskin.web.protocol.records.CRecordWebNotifyClick1;
import de.sillysky.nyssr.remoteskin.web.protocol.records.CRecordWebNotifyClick2;
import de.sillysky.nyssr.session.CConstantsSession;
import de.sillysky.nyssr.session.api.records.CRecordUserDbChangePassword;
import de.sillysky.nyssr.target.CTarget;
import de.sillysky.nyssr.target.ITarget;
import de.sillysky.nyssr.target.registry.records.CRecordStartTarget;
import de.sillysky.nyssr.util.CUtilString;
import de.sillysky.nyssr.util.properties.CStringProperties;
import org.jetbrains.annotations.NotNull;

class C00309ChangePassword
extends CTarget {
    private final CTargetAddress mClientTargetAddress;
    private final CTargetAddress mOwnerTargetAddress;
    private final String mUserId;
    private CWebApi mWebApi;
    private CWebDialogApi mWebDialogApi;
    private static final String ID_INDEX_MODAL = "rs_30cb3f8d-cefd-40c5-81b8-7791895c7b95";
    private static final String ID_00309_MODAL = "id_00309_modal";
    private static final String ID_00309_CANCEL = "id_00309_cancel";
    private static final String ID_00309_SAVE = "id_00309_save";
    private static final String ID_00309_OLD_PW = "id_00309_old_pw";
    private static final String ID_00309_NEW_PW1 = "id_00309_new_pw1";
    private static final String ID_00309_NEW_PW2 = "id_00309_new_pw2";
    private static final String ID_00309_OLD_PW_ALERT = "id_00309_old_pw_alert";
    private static final String ID_00309_NEW_PW_ALERT = "id_00309_new_pw_alert";
    private static final String[] WIDGETS = new String[]{"id_00309_cancel", "id_00309_save"};
    private CTargetAddress mUserDbAddress;

    public C00309ChangePassword(@NotNull CTargetAddress aClientTargetAddress, @NotNull CTargetAddress aOwnerTargetAddress, @NotNull String aUserId) {
        this.mClientTargetAddress = aClientTargetAddress;
        this.mOwnerTargetAddress = aOwnerTargetAddress;
        this.mUserId = aUserId;
        this.addMessageHandler(CRecordStartTarget.ID, this::asyncStartTarget);
        this.addMessageHandler(CRecordWebDismissDialog.ID, this::asyncWebDismissDialog);
        this.addMessageHandler(CRecordWebNotifyClick1.ID, this::asyncWebNotifyClick1);
        this.addMessageHandler(CRecordWebNotifyClick2.ID, this::asyncWebNotifyClick2);
        this.addMessageHandler(CRecordUserDbChangePassword.ID, this::asyncChangePassword);
    }

    private boolean asyncStartTarget(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        this.mWebApi = new CWebApi((ITarget)this, this.mClientTargetAddress);
        this.mWebDialogApi = new CWebDialogApi((ITarget)this, this.mClientTargetAddress);
        this.mWebApi.registerWidgets(WIDGETS);
        this.showDialog();
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncWebDismissDialog(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        this.finish(3);
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncWebNotifyClick1(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        CStringProperties values = CRecordWebNotifyClick1.getValues((CRecord)aRecord, null);
        if (values != null) {
            this.mWebApi.setInnerHtml(ID_00309_OLD_PW_ALERT, "");
            this.mWebApi.setInnerHtml(ID_00309_NEW_PW_ALERT, "");
            boolean errors = false;
            String old_pw = values.get(ID_00309_OLD_PW, "");
            if ("OLBgp1GsljhM2TJ+sbHjaiH9txEUvgdDTAzHv2P24donTt6/529l+9Ua0vFImLlb".equals(old_pw) && !"guest".equals(this.mUserId)) {
                String alert = CUtilJson.loadJson(((Object)((Object)this)).getClass(), (String)"/html/00309_alert.html");
                alert = CUtilString.replaceFirstOccurrence((String)alert, (String)"{message}", (String)"The password is empty.");
                this.mWebApi.setInnerHtml(ID_00309_OLD_PW_ALERT, alert);
                errors = true;
            }
            String new_pw1 = values.get(ID_00309_NEW_PW1, "");
            String new_pw2 = values.get(ID_00309_NEW_PW2, "");
            if ("OLBgp1GsljhM2TJ+sbHjaiH9txEUvgdDTAzHv2P24donTt6/529l+9Ua0vFImLlb".equals(new_pw1)) {
                String alert = CUtilJson.loadJson(((Object)((Object)this)).getClass(), (String)"/html/00309_alert.html");
                alert = CUtilString.replaceFirstOccurrence((String)alert, (String)"{message}", (String)"Empty passwords are not allowed.");
                this.mWebApi.setInnerHtml(ID_00309_NEW_PW_ALERT, alert);
                errors = true;
            } else if (!new_pw1.equals(new_pw2)) {
                String alert = CUtilJson.loadJson(((Object)((Object)this)).getClass(), (String)"/html/00309_alert.html");
                alert = CUtilString.replaceFirstOccurrence((String)alert, (String)"{message}", (String)"The passwords are different.");
                this.mWebApi.setInnerHtml(ID_00309_NEW_PW_ALERT, alert);
                errors = true;
            }
            if (!errors) {
                this.sendChangePassword(this.mUserId, old_pw, new_pw1);
            }
        } else {
            this.finish(1);
        }
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncWebNotifyClick2(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        this.finish(2);
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncChangePassword(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            this.mUserDbAddress = aEnvelope.getSender();
            int resultCode = aEnvelope.getResultCode();
            if (resultCode == 0) {
                this.finish(0);
            } else if (resultCode == 5103) {
                String alert = CUtilJson.loadJson(((Object)((Object)this)).getClass(), (String)"/html/00309_alert.html");
                alert = CUtilString.replaceFirstOccurrence((String)alert, (String)"{message}", (String)"The password is wrong.");
                this.mWebApi.setInnerHtml(ID_00309_OLD_PW_ALERT, alert);
            } else {
                this.finish(1);
            }
            return true;
        }
        return false;
    }

    private void showDialog() throws CException {
        String main = CUtilJson.loadJson(((Object)((Object)this)).getClass(), (String)"/html/00309_change_password.html");
        main = CUtilString.replaceAllOccurrences((String)main, (String)"{userid}", (String)this.mUserId);
        this.mWebApi.removeElement(ID_00309_MODAL);
        this.mWebApi.setInnerHtml(ID_INDEX_MODAL, main);
        this.mWebApi.showModal(ID_00309_MODAL);
        this.mWebApi.addClickListener1(ID_00309_SAVE, new String[]{ID_00309_OLD_PW, ID_00309_NEW_PW1, ID_00309_NEW_PW2});
        this.mWebApi.addClickListener2(new String[]{ID_00309_CANCEL});
    }

    private void sendMessageToSessionManager(@NotNull CRecord aRecord) throws CException {
        CEnvelope env = this.mUserDbAddress != null ? CEnvelope.forSingleTarget((CTargetAddress)this.mUserDbAddress) : CEnvelope.forMicroService((IId)CConstantsSession.MICRO_SERVICE_ID);
        this.sendRequest(env, aRecord);
    }

    private void sendChangePassword(@NotNull String aUserId, @NotNull String aOldPw, @NotNull String aNewPw) throws CException {
        CRecord record = CRecordUserDbChangePassword.create();
        CRecordUserDbChangePassword.setUserId((CRecord)record, (String)aUserId);
        CRecordUserDbChangePassword.setCurrentPassword((CRecord)record, (String)aOldPw);
        CRecordUserDbChangePassword.setNewPassword((CRecord)record, (String)aNewPw);
        this.sendMessageToSessionManager(record);
    }

    private void finish(int aReason) throws CException {
        this.mWebApi.removeElement(ID_00309_MODAL);
        this.mWebDialogApi.notifyDismissed(this.mOwnerTargetAddress, CConstants.MICRO_SERVICE_ID, aReason, null);
        this.mWebApi.deregisterWidgetOwner();
        this.deregisterTarget();
    }
}

