/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.web.dialog.yesno;

import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.impl.web.dialog.yesno.CConstants;
import de.sillysky.nyssr.json.CUtilJson;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.remoteskin.web.dialog.records.CRecordWebDismissDialog;
import de.sillysky.nyssr.remoteskin.web.protocol.CWebApi;
import de.sillysky.nyssr.remoteskin.web.protocol.CWebDialogApi;
import de.sillysky.nyssr.remoteskin.web.protocol.records.CRecordWebNotifyClick2;
import de.sillysky.nyssr.target.CTarget;
import de.sillysky.nyssr.target.ITarget;
import de.sillysky.nyssr.target.registry.records.CRecordStartTarget;
import de.sillysky.nyssr.util.CUtilString;
import de.sillysky.nyssr.util.properties.CStringProperties;
import org.jetbrains.annotations.NotNull;

class C00001YesNo
extends CTarget {
    private final CTargetAddress mClientTargetAddress;
    private final CTargetAddress mOwnerTargetAddress;
    private final String mParentWidgetId;
    private final CStringProperties mParams;
    private CWebApi mWebApi;
    private CWebDialogApi mWebDialogApi;
    private static final String ID_INDEX_MODAL = "rs_30cb3f8d-cefd-40c5-81b8-7791895c7b95";
    private static final String ID_00001_MODAL = "id_00001_modal";
    private static final String ID_00001_NO = "id_00001_no";
    private static final String ID_00001_YES = "id_00001_yes";
    private static final String ID_00001_MESSAGE = "id_00001_message";
    private static final String[] WIDGETS = new String[]{"id_00001_no", "id_00001_yes"};

    public C00001YesNo(@NotNull CTargetAddress aClientTargetAddress, @NotNull CTargetAddress aOwnerTargetAddress, @NotNull String aParentWidgetId, @NotNull CStringProperties aParams) {
        this.mClientTargetAddress = aClientTargetAddress;
        this.mOwnerTargetAddress = aOwnerTargetAddress;
        this.mParentWidgetId = aParentWidgetId;
        this.mParams = aParams;
        this.addMessageHandler(CRecordStartTarget.ID, this::asyncStartTarget);
        this.addMessageHandler(CRecordWebDismissDialog.ID, this::asyncWebDismissDialog);
        this.addMessageHandler(CRecordWebNotifyClick2.ID, this::asyncWebNotifyClick2);
    }

    private boolean asyncStartTarget(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        this.mWebApi = new CWebApi((ITarget)this, this.mClientTargetAddress);
        this.mWebDialogApi = new CWebDialogApi((ITarget)this, this.mClientTargetAddress);
        this.mWebApi.registerWidgets(WIDGETS);
        this.showDialog();
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncWebDismissDialog(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        this.finish(3, false);
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncWebNotifyClick2(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        String id = CRecordWebNotifyClick2.getId((CRecord)aRecord, null);
        this.finish(0, ID_00001_YES.equals(id));
        aEnvelope.setResultSuccess();
        return true;
    }

    private void showDialog() throws CException {
        String main = CUtilJson.loadJson(((Object)((Object)this)).getClass(), (String)"/html/00001_yes_no.html");
        main = CUtilString.replaceFirstOccurrence((String)main, (String)"{message}", (String)this.mParams.get("message"));
        this.mWebApi.setInnerHtml(this.mParentWidgetId, main);
        this.mWebApi.showModal(ID_00001_MODAL);
        this.mWebApi.addClickListener2(new String[]{ID_00001_NO, ID_00001_YES});
    }

    private void finish(int aReason, boolean aYes) throws CException {
        this.mWebApi.removeElement(ID_00001_MODAL);
        this.mParams.put("result", aYes ? "yes" : "no");
        this.mWebDialogApi.notifyDismissed(this.mOwnerTargetAddress, CConstants.MICRO_SERVICE_ID, aReason, this.mParams);
        this.mWebApi.deregisterWidgetOwner();
        this.deregisterTarget();
    }
}

