/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.remoteskin.client.swing.widget.spinner;

import de.sillysky.nyssr.impl.remoteskin.client.swing.widget.CSwingSlider;
import de.sillysky.nyssr.impl.remoteskin.client.swing.widget.spinner.CSwingSpinner;
import de.sillysky.nyssr.json.CJsonObject;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.remoteskin.model.CAttributeHandlerList;
import de.sillysky.nyssr.remoteskin.model.CWidgetSet;
import de.sillysky.nyssr.remoteskin.model.EWidgetTypes;
import de.sillysky.nyssr.util.CUtilInteger;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CSwingIntegerSpinner
extends CSwingSpinner {
    private static final ILogger LOG = CLoggerFactory.getLogger(CSwingSlider.class);

    public CSwingIntegerSpinner(@NotNull CWidgetSet aWidgetSet, @NotNull String aId, @NotNull CJsonObject aAttributes) {
        super(aWidgetSet, aId);
        SpinnerNumberModel nm = new SpinnerNumberModel(0, Integer.MIN_VALUE, Integer.MAX_VALUE, 1);
        this.getComponent().setModel(nm);
        CAttributeHandlerList list = this.getAttributeHandlerList();
        list.addHandler("value", this::applyValue);
        list.addHandler("valueInt", this::applyValue);
        list.addHandler("minimum", this::applyMinimum);
        list.addHandler("minimumInt", this::applyMinimum);
        list.addHandler("maximum", this::applyMaximum);
        list.addHandler("maximumInt", this::applyMaximum);
        list.addHandler("stepSize", this::applyStepSize);
        list.addHandler("stepSizeInt", this::applyStepSize);
    }

    @Override
    public void addListeners() {
        super.addListeners();
        this.getComponent().addChangeListener(this::onChange);
    }

    private boolean applyStepSize(@NotNull String aKey, @Nullable Object aValue) {
        if (aValue instanceof Number) {
            int value = CUtilInteger.fromObject((Object)aValue, (int)1);
            LOG.debug("Set Spinner step size to {}", new Object[]{value});
            this.getNumberModel().setStepSize(value);
            return true;
        }
        return false;
    }

    private boolean applyMaximum(@NotNull String aKey, @Nullable Object aValue) {
        if (aValue instanceof Number) {
            int value = CUtilInteger.fromObject((Object)aValue, (int)Integer.MAX_VALUE);
            LOG.debug("Set Spinner maximum to {}", new Object[]{value});
            this.getNumberModel().setMaximum(Integer.valueOf(value));
            return true;
        }
        return false;
    }

    private boolean applyMinimum(@NotNull String aKey, @Nullable Object aValue) {
        if (aValue instanceof Number) {
            int value = CUtilInteger.fromObject((Object)aValue, (int)Integer.MIN_VALUE);
            LOG.debug("Set Spinner minimum to {}", new Object[]{value});
            this.getNumberModel().setMinimum(Integer.valueOf(value));
            return true;
        }
        return false;
    }

    private boolean applyValue(@NotNull String aKey, @Nullable Object aValue) {
        if (aValue instanceof Number) {
            int value = CUtilInteger.fromObject((Object)aValue, (int)0);
            LOG.debug("Set Spinner value to {}", new Object[]{value});
            this.startEdit();
            this.getNumberModel().setValue(value);
            this.stopEdit();
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public String getWidgetType() {
        return EWidgetTypes.IntegerSpinner.name();
    }

    @Override
    protected void onChange(@NotNull ChangeEvent aEvent) {
        String value;
        if (this.isOnChange() && !this.isEditInProgress() && (value = this.getValueString()) != null) {
            LOG.debug("value is {}", new Object[]{value});
            this.addNotification("onChangeInt", value);
            this.sendNotification();
        }
    }

    private SpinnerNumberModel getNumberModel() {
        return (SpinnerNumberModel)this.getComponent().getModel();
    }
}

