/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.remoteskin.client.util;

import de.sillysky.nyssr.remoteskin.model.CWidget;
import de.sillysky.nyssr.remoteskin.model.EFileDeliveryType;
import de.sillysky.nyssr.remoteskin.model.enums.EIconUsage;
import de.sillysky.nyssr.remoteskin.model.events.CEventIcon;
import de.sillysky.nyssr.remoteskin.model.events.CEventIcons;
import de.sillysky.nyssr.util.CUtilString;
import java.util.Collection;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CIconHandler {
    private final CWidget mOwner;

    protected CIconHandler(@NotNull CWidget aOwner) {
        this.mOwner = aOwner;
    }

    public boolean handleEvent(@Nullable Object aValue, @Nullable EIconUsage aUsage) {
        CEventIcon event = CEventIcon.fromObject((Object)aValue);
        if (event != null) {
            return this.handleIcon(event, aUsage);
        }
        return false;
    }

    public boolean handleEvent(@Nullable Object aEvent) {
        return this.handleEvent(aEvent, null);
    }

    public boolean handleIcon(@NotNull CEventIcon aEvent, @Nullable EIconUsage aUsage) {
        EIconUsage usageFromEvent;
        EIconUsage usage = aUsage != null ? aUsage : ((usageFromEvent = aEvent.getUsage()) == null ? EIconUsage.enabled : usageFromEvent);
        String path = aEvent.getPath();
        if (CUtilString.isValid((String)path)) {
            this.mOwner.getWidgetSet().getContext().requestFile(path, this.mOwner.getId(), (Object)usage, EFileDeliveryType.AS_IMAGE);
            return true;
        }
        ImageIcon icon = aEvent.createIcon(this.getClass());
        if (icon != null) {
            this.setIcon(icon, usage);
            return true;
        }
        return false;
    }

    public void fileArrived(@Nullable Object aToken, @NotNull ImageIcon aImage) {
        if (aToken instanceof EIconUsage) {
            this.setIcon(aImage, (EIconUsage)aToken);
        }
    }

    protected abstract void setIcon(@NotNull Icon var1, EIconUsage var2);

    public boolean handleEvents(Object aValue) {
        CEventIcons event = CEventIcons.create((Object)aValue);
        if (event != null) {
            Collection icons = event.getIcons();
            for (CEventIcon icon : icons) {
                this.handleIcon(icon, null);
            }
            return true;
        }
        return false;
    }
}

