/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.microservice.registry.records;

import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.record.IGeneratedRecord;
import de.sillysky.nyssr.slot.CCommonSlotType;
import de.sillysky.nyssr.slot.CSlotFactoryHelper;
import de.sillysky.nyssr.slot.CSlotType;
import de.sillysky.nyssr.slot.ISlot;
import java.time.ZonedDateTime;
import org.jetbrains.annotations.NotNull;

public final class CRecordMicroServiceInstance
implements IGeneratedRecord {
    public static final IId ID = CIdFactory.fromObject((Object)"116d6164-0769-4774-92d6-258b0807163a");
    public static final String NAME = "MicroServiceInstance";
    public static final String DESCRIPTION = "A micro service instance.";
    public static final String SLOT_MICRO_SERVICE_ADDRESS = "3";
    public static final String SLOT_MICRO_SERVICE_ID = "1";
    public static final String SLOT_MICRO_SERVICE_INSTANCE_ID = "2";
    public static final String SLOT_TIME_ADDED = "4";
    public static final String[] NAMESPACES = new String[0];
    public static final boolean IS_NANO_SERVICE = false;

    @NotNull
    public static CRecord create() {
        return new CRecord(ID);
    }

    public static CTargetAddress getMicroServiceAddress(@NotNull CRecord aRecord, CTargetAddress aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_MICRO_SERVICE_ADDRESS);
        if (slot == null) {
            return aDefault;
        }
        return (CTargetAddress)slot.getValue();
    }

    public static IId getMicroServiceId(@NotNull CRecord aRecord, IId aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_MICRO_SERVICE_ID);
        if (slot == null) {
            return aDefault;
        }
        return (IId)slot.getValue();
    }

    public static IId getMicroServiceInstanceId(@NotNull CRecord aRecord, IId aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_MICRO_SERVICE_INSTANCE_ID);
        if (slot == null) {
            return aDefault;
        }
        return (IId)slot.getValue();
    }

    public static ZonedDateTime getTimeAdded(@NotNull CRecord aRecord, ZonedDateTime aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_TIME_ADDED);
        if (slot == null) {
            return aDefault;
        }
        return (ZonedDateTime)slot.getValue();
    }

    public static void setMicroServiceAddress(@NotNull CRecord aRecord, CTargetAddress aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.TARGET_ADDRESS, (Object)aValue);
        aRecord.addSlot(SLOT_MICRO_SERVICE_ADDRESS, slot);
    }

    public static void setMicroServiceId(@NotNull CRecord aRecord, IId aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.ID, (Object)aValue);
        aRecord.addSlot(SLOT_MICRO_SERVICE_ID, slot);
    }

    public static void setMicroServiceInstanceId(@NotNull CRecord aRecord, IId aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.ID, (Object)aValue);
        aRecord.addSlot(SLOT_MICRO_SERVICE_INSTANCE_ID, slot);
    }

    public static void setTimeAdded(@NotNull CRecord aRecord, ZonedDateTime aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.ZONED_DATE_TIME, (Object)aValue);
        aRecord.addSlot(SLOT_TIME_ADDED, slot);
    }
}

