/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.remoteskin.client.swing.widget;

import de.sillysky.nyssr.impl.remoteskin.client.swing.widget.CSwingJComponent;
import de.sillysky.nyssr.json.CJsonObject;
import de.sillysky.nyssr.remoteskin.model.CAttributeHandlerList;
import de.sillysky.nyssr.remoteskin.model.CWidgetSet;
import de.sillysky.nyssr.remoteskin.model.EWidgetTypes;
import de.sillysky.nyssr.remoteskin.model.events.CEventColor;
import javax.swing.JColorChooser;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CSwingColorChooser
extends CSwingJComponent {
    private final JColorChooser mComponent = new JColorChooser();

    CSwingColorChooser(@NotNull CWidgetSet aWidgetSet, @NotNull String aId, @NotNull CJsonObject aAttributes) {
        super(aWidgetSet, aId);
        CAttributeHandlerList list = this.getAttributeHandlerList();
        list.addHandler("color", this::applyColor);
        list.addHandler("title", this::applyTitle);
    }

    private boolean applyColor(@NotNull String aKey, @Nullable Object aValue) {
        CEventColor event = CEventColor.create((Object)aValue);
        if (event != null) {
            this.mComponent.setColor(event.createColor());
            return true;
        }
        return false;
    }

    private boolean applyTitle(@NotNull String aKey, @Nullable Object aValue) {
        if (aValue instanceof String) {
            // empty if block
        }
        return false;
    }

    @NotNull
    public JColorChooser getComponent() {
        return this.mComponent;
    }

    @Override
    @NotNull
    public String getWidgetType() {
        return EWidgetTypes.ColorChooser.name();
    }
}

