/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.remoteskin.client.context.target;

import de.sillysky.nyssr.impl.remoteskin.client.context.target.CFileRequester;
import de.sillysky.nyssr.util.CUtilUuid;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;

class CFileEntry {
    private final UUID mTransactionId;
    private final String mRelativePath;
    private final long mSystemTick;
    private final List<CFileRequester> mRequesters = new ArrayList<CFileRequester>();

    CFileEntry(@NotNull String aRelativePath, @NotNull CFileRequester aRequester) {
        this.mTransactionId = CUtilUuid.random();
        this.mRelativePath = aRelativePath;
        this.mSystemTick = System.currentTimeMillis();
        this.addRequester(aRequester);
    }

    @NotNull
    UUID getTransactionId() {
        return this.mTransactionId;
    }

    @NotNull
    List<CFileRequester> getRequesters() {
        return this.mRequesters;
    }

    @NotNull
    String getRelativePath() {
        return this.mRelativePath;
    }

    long getSystemTick() {
        return this.mSystemTick;
    }

    void addRequester(@NotNull CFileRequester aRequester) {
        this.mRequesters.add(aRequester);
    }
}

