/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.network.broadcast;

import de.sillysky.nyssr.impl.network.broadcast.CBroadcastService;
import de.sillysky.nyssr.impl.network.broadcast.IDependencies;
import de.sillysky.nyssr.kernel.configuration.IKernelConfiguration;
import de.sillysky.nyssr.message.IMessageSender;
import de.sillysky.nyssr.namedb.INameDb;
import de.sillysky.nyssr.namespace.INamespaceFactory;
import de.sillysky.nyssr.network.IConnectionRegistry;
import de.sillysky.nyssr.service.IServiceDependencyList;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.service.IServiceStarter;
import org.jetbrains.annotations.NotNull;

public final class CPackageImplNetworkBroadcast
implements IServiceStarter,
IDependencies {
    private CBroadcastService mBroadcastService;
    private INamespaceFactory mNamespaceFactory;
    private IMessageSender mMessageSender;
    private INameDb mNameDb;
    private IConnectionRegistry mConnectionRegistry;
    private IKernelConfiguration mKernelConfiguration;

    public void getDependencies(@NotNull IServiceDependencyList aDependencyList) {
        aDependencyList.add(INamespaceFactory.class);
        aDependencyList.add(IMessageSender.class);
        aDependencyList.add(INameDb.class);
        aDependencyList.add(IConnectionRegistry.class);
        aDependencyList.add(IKernelConfiguration.class);
    }

    public void start(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        if (this.mBroadcastService == null) {
            this.mNamespaceFactory = (INamespaceFactory)aServiceRegistry.getServiceOrThrow(INamespaceFactory.class);
            this.mMessageSender = (IMessageSender)aServiceRegistry.getServiceOrThrow(IMessageSender.class);
            this.mNameDb = (INameDb)aServiceRegistry.getServiceOrThrow(INameDb.class);
            this.mConnectionRegistry = (IConnectionRegistry)aServiceRegistry.getServiceOrThrow(IConnectionRegistry.class);
            this.mKernelConfiguration = (IKernelConfiguration)aServiceRegistry.getServiceOrThrow(IKernelConfiguration.class);
            this.mBroadcastService = new CBroadcastService(this);
            this.mBroadcastService.activate(aServiceRegistry);
        }
    }

    public void stop(@NotNull IServiceRegistry aServiceRegistry) {
        if (this.mBroadcastService != null) {
            this.mBroadcastService.deactivate(aServiceRegistry);
            this.mBroadcastService = null;
        }
    }

    @Override
    @NotNull
    public INamespaceFactory getNamespaceFactory() {
        return this.mNamespaceFactory;
    }

    @Override
    @NotNull
    public IMessageSender getMessageSender() {
        return this.mMessageSender;
    }

    @Override
    @NotNull
    public INameDb getNameDb() {
        return this.mNameDb;
    }

    @Override
    @NotNull
    public IConnectionRegistry getConnectionRegistry() {
        return this.mConnectionRegistry;
    }

    @Override
    @NotNull
    public IKernelConfiguration getKernelConfiguration() {
        return this.mKernelConfiguration;
    }
}

