/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.network.router;

import de.sillysky.nyssr.address.CNodeAddress;

final class CDijkstraNode {
    private final CNodeAddress mNodeId;
    private boolean mIsSettled;
    private boolean mIsUnSettled;
    private CNodeAddress mPrevious;
    private int mTotalCosts;

    CDijkstraNode(CNodeAddress aId) {
        this.mNodeId = aId;
        this.mPrevious = null;
        this.mIsSettled = false;
        this.mIsUnSettled = false;
        this.mTotalCosts = Integer.MAX_VALUE;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CDijkstraNode other = (CDijkstraNode)obj;
        if (this.mNodeId == null) {
            return other.mNodeId == null;
        }
        return this.mNodeId.equals((Object)other.mNodeId);
    }

    CNodeAddress getNodeId() {
        return this.mNodeId;
    }

    CNodeAddress getPrevious() {
        return this.mPrevious;
    }

    int getTotalCosts() {
        return this.mTotalCosts;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.mNodeId == null ? 0 : this.mNodeId.hashCode());
        return result;
    }

    boolean isSettled() {
        return this.mIsSettled;
    }

    boolean isUnSettled() {
        return this.mIsUnSettled;
    }

    void reset() {
        this.mIsSettled = false;
        this.mIsUnSettled = false;
    }

    void setPrevious(CNodeAddress aNodeId) {
        this.mPrevious = aNodeId;
    }

    void setTotalCosts(int aTotalCosts) {
        this.mTotalCosts = aTotalCosts;
    }

    void settle() {
        this.mIsUnSettled = false;
        this.mIsSettled = true;
    }

    public String toString() {
        return this.mNodeId.toString() + "(" + this.mTotalCosts + ")";
    }

    void unSettle() {
        this.mIsUnSettled = true;
    }
}

