/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.network.router.target;

import de.sillysky.nyssr.impl.network.router.IInternalRouter;
import de.sillysky.nyssr.impl.network.router.target.CTargetForRouter;
import de.sillysky.nyssr.impl.network.router.target.IDependencies;
import de.sillysky.nyssr.namedb.INameDb;
import de.sillysky.nyssr.namespace.INamespaceFactory;
import de.sillysky.nyssr.network.nodeinfo.INodeInfoDatabase;
import de.sillysky.nyssr.network.router.IRouter;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceDependencyList;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.service.IServiceStarter;
import org.jetbrains.annotations.NotNull;

public final class CPackageImplNetworkRouterTarget
implements IServiceStarter,
IDependencies {
    private IService mService;
    private INameDb mNameDb;
    private IRouter mRouter;
    private IInternalRouter mInternalRouter;
    private INodeInfoDatabase mNodeInfoDatabase;
    private INamespaceFactory mNamespaceFactory;

    public void getDependencies(@NotNull IServiceDependencyList aDependencyList) {
        aDependencyList.add(INameDb.class);
        aDependencyList.add(IRouter.class);
        aDependencyList.add(IInternalRouter.class);
        aDependencyList.add(INodeInfoDatabase.class);
        aDependencyList.add(INamespaceFactory.class);
    }

    public void start(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        if (this.mService == null) {
            this.mNameDb = (INameDb)aServiceRegistry.getServiceOrThrow(INameDb.class);
            this.mRouter = (IRouter)aServiceRegistry.getServiceOrThrow(IRouter.class);
            this.mInternalRouter = (IInternalRouter)aServiceRegistry.getServiceOrThrow(IInternalRouter.class);
            this.mNodeInfoDatabase = (INodeInfoDatabase)aServiceRegistry.getServiceOrThrow(INodeInfoDatabase.class);
            this.mNamespaceFactory = (INamespaceFactory)aServiceRegistry.getServiceOrThrow(INamespaceFactory.class);
            this.mService = new CTargetForRouter(this);
            this.mService.activate(aServiceRegistry);
        }
    }

    public void stop(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        if (this.mService != null) {
            this.mService.deactivate(aServiceRegistry);
            this.mService = null;
        }
    }

    @Override
    @NotNull
    public INameDb getNameDb() {
        return this.mNameDb;
    }

    @Override
    @NotNull
    public IRouter getRouter() {
        return this.mRouter;
    }

    @Override
    @NotNull
    public IInternalRouter getInternalRouter() {
        return this.mInternalRouter;
    }

    @Override
    @NotNull
    public INodeInfoDatabase getNodeInfoDatabase() {
        return this.mNodeInfoDatabase;
    }

    @Override
    @NotNull
    public INamespaceFactory getNamespaceFactory() {
        return this.mNamespaceFactory;
    }
}

