/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.dialog.user;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.widget.CWidgetId;
import de.sillysky.nyssr.id.widget.CWidgetSetId;
import de.sillysky.nyssr.impl.dialog.user.CButtonAndRight;
import de.sillysky.nyssr.impl.dialog.user.CMainTarget;
import de.sillysky.nyssr.impl.dialog.user.CUtilUserDialog;
import de.sillysky.nyssr.remoteskin.model.events.CEventButtonPressedNotification;
import de.sillysky.nyssr.remoteskin.model.events.CEventIcon;
import de.sillysky.nyssr.remoteskin.model.events.CEventListSelectionNotification;
import de.sillysky.nyssr.remoteskin.model.events.CEventWindowNotification;
import de.sillysky.nyssr.remoteskin.model.events.dialogs.CEventShowMessageDialog;
import de.sillysky.nyssr.remoteskin.server.context.IRemoteSkinServerContext;
import de.sillysky.nyssr.remoteskin.server.context.IWidgetApi;
import de.sillysky.nyssr.remoteskin.server.listeners.IButtonPressedListener;
import de.sillysky.nyssr.remoteskin.server.listeners.IListSelectionListener;
import de.sillysky.nyssr.remoteskin.server.listeners.IListener;
import de.sillysky.nyssr.remoteskin.server.listeners.IMessageDialogListener;
import de.sillysky.nyssr.remoteskin.server.listeners.IWindowClosingListener;
import de.sillysky.nyssr.session.api.CRight;
import de.sillysky.nyssr.util.CUtilCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class C704Handler {
    private final CMainTarget mMainTarget;
    private final IRemoteSkinServerContext mServerContext;
    private final IWidgetApi mApi;
    private final CWidgetSetId mWs704;
    private final CWidgetId m704Dialog;
    private final CWidgetId m704ListRights;
    private final CWidgetId m704ButtonAdd;
    private final CWidgetId m704ButtonRemove;
    private final List<String> mSelectedRights = new ArrayList<String>();
    private final CButtonAndRight mButtonAndRight;
    private boolean m704open;
    private CWidgetId mParentWidget;
    private Collection<CRight> mRights;

    C704Handler(@NotNull CMainTarget aMainTarget, @NotNull IRemoteSkinServerContext aServerContext, @NotNull String aInstance, @NotNull CButtonAndRight aButtonAndRight) {
        this.mMainTarget = aMainTarget;
        this.mServerContext = aServerContext;
        this.mButtonAndRight = aButtonAndRight;
        this.mApi = this.mServerContext.getWidgetApi();
        this.mWs704 = CWidgetSetId.create((String)"@704_EditRights", (String)aInstance);
        this.m704Dialog = CWidgetId.create((String)"#704_Dialog", (CWidgetSetId)this.mWs704);
        this.mApi.addListener(this.m704Dialog, (IListener)((IWindowClosingListener)this::onDialogClosing));
        this.m704ListRights = CWidgetId.create((String)"#704_ListRights", (CWidgetSetId)this.mWs704);
        this.mApi.addListener(this.m704ListRights, (IListener)((IListSelectionListener)this::onListRightSelection));
        this.m704ButtonAdd = CWidgetId.create((String)"#704_ButtonAdd", (CWidgetSetId)this.mWs704);
        this.mApi.addListener(this.m704ButtonAdd, (IListener)((IButtonPressedListener)this::onButtonAdd));
        this.m704ButtonRemove = CWidgetId.create((String)"#704_ButtonRemove", (CWidgetSetId)this.mWs704);
        this.mApi.addListener(this.m704ButtonRemove, (IListener)((IButtonPressedListener)this::onButtonRemove));
        this.mApi.addListener(this.m704ButtonRemove, (IListener)((IMessageDialogListener)this::onMessageRemoveRight));
        CWidgetId buttonOkay = CWidgetId.create((String)"#704_ButtonOkay", (CWidgetSetId)this.mWs704);
        this.mApi.addListener(buttonOkay, (IListener)((IButtonPressedListener)this::onButtonOkay));
    }

    private void onMessageRemoveRight(@Nullable String aResult) throws CException {
        if ("Okay".equals(aResult)) {
            this.mMainTarget.sendRemoveRights(this.mSelectedRights);
        }
    }

    private void onDialogClosing(@NotNull CEventWindowNotification aWindowEvent) {
        this.unmount();
    }

    void mount(@NotNull CWidgetId aParentWidget) {
        if (!this.m704open) {
            this.m704open = true;
            this.mParentWidget = aParentWidget;
            this.mButtonAndRight.add(this.m704ButtonRemove);
            this.mServerContext.mountWidgetSet(this.mWs704, this.mParentWidget, "#704_PanelBackground", this::widgetSetMounted);
            this.sendUpdate();
        }
    }

    void setRights(@NotNull Collection<CRight> aRights) {
        this.mRights = new ArrayList<CRight>(aRights);
        if (this.m704open) {
            this.fillRights();
            this.sendUpdate();
        }
    }

    private void fillRights() {
        if (this.m704open && this.mRights != null) {
            CUtilUserDialog.fillList(this.mApi, this.m704ListRights, this.mRights);
        }
    }

    private void widgetSetMounted(@NotNull CWidgetSetId aWidgetSetId) {
        if (this.mWs704.equals((Object)aWidgetSetId)) {
            this.mApi.pack(this.m704Dialog);
            this.mApi.centerWidget(this.m704Dialog, this.mParentWidget);
            this.fillRights();
            this.mApi.setVisible(this.m704Dialog, true);
            this.sendUpdate();
        }
    }

    void unmount() {
        if (this.m704open) {
            this.m704open = false;
            this.mApi.unmount(this.m704Dialog);
            this.sendUpdate();
        }
    }

    private void sendUpdate() {
        this.mServerContext.sendUpdate();
    }

    private void onButtonAdd(@NotNull CEventButtonPressedNotification aEvent) {
        this.mMainTarget.showDialog705NewRight(this.m704ButtonAdd);
    }

    private void onButtonRemove(@NotNull CEventButtonPressedNotification aEvent) {
        String s = CUtilCollection.toString(this.mSelectedRights);
        CEventShowMessageDialog event = new CEventShowMessageDialog("Do you really want to remove the rights \"" + s + "?\"");
        event.setTitle("Remove Right");
        event.setButtons(new String[]{"Okay", "Cancel"});
        event.setDefaultButton("Okay");
        event.setIcon(CEventIcon.fromObject((Object)"user.png"));
        this.mApi.showMessageDialog(this.m704ButtonRemove, event);
        this.mServerContext.sendUpdate();
    }

    private void onButtonOkay(@NotNull CEventButtonPressedNotification aEvent) {
        this.unmount();
    }

    private void onListRightSelection(@NotNull CEventListSelectionNotification aEvent) {
        this.mSelectedRights.clear();
        List selectedIds = aEvent.getSelectedIds();
        this.mSelectedRights.addAll(selectedIds);
        this.mButtonAndRight.check(CUtilCollection.getFirst((Collection)selectedIds), null, this.m704ButtonRemove, "NY_DeleteRight");
        this.sendUpdate();
    }
}

