/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.network.nodes;

import de.sillysky.nyssr.address.CNodeAddress;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.network.nodeinfo.CNodeInfo;
import de.sillysky.nyssr.network.nodeinfo.CNodeInfoDto;
import de.sillysky.nyssr.util.CUtilString;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CNodeInfoList {
    private static final ILogger LOG = CLoggerFactory.getLogger(CNodeInfoList.class);
    private final Map<CNodeAddress, CNodeInfoDto> mNodes = new HashMap<CNodeAddress, CNodeInfoDto>();

    CNodeInfoList() {
    }

    void dump() {
        if (LOG.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder(1000);
            sb.append(CUtilString.LINE_CRLF);
            sb.append("| NodeId SegmentId Description License\n");
            for (CNodeInfoDto dto : this.mNodes.values()) {
                CNodeAddress address = dto.getNodeAddress();
                sb.append(String.format("%-15.15s", address.getNodeId()));
                sb.append(String.format("%-30.30s", address.getSegmentId()));
                sb.append(String.format("%-30.30s", dto.getDescription()));
                sb.append(String.format("%-37.37s", dto.getLicense()));
                sb.append("\n");
            }
            sb.append(CUtilString.LINE_CRLF);
            LOG.debug(sb.toString());
        }
    }

    @NotNull
    Collection<CNodeInfoDto> getNodeInfoDtoCollection() {
        return new ArrayList<CNodeInfoDto>(this.mNodes.values());
    }

    @NotNull
    List<CNodeInfo> getNodeInfos(@NotNull Collection<CNodeAddress> aNodeAddresses) {
        ArrayList<CNodeInfo> result = new ArrayList<CNodeInfo>();
        for (CNodeAddress nodeAddress : aNodeAddresses) {
            CNodeInfoDto node = this.getOrCreateNodeRecord(nodeAddress);
            result.add(node.getNodeInfo());
        }
        return result;
    }

    @Nullable
    CNodeInfoDto get(@NotNull CNodeAddress aNodeAddress) {
        return this.mNodes.get(aNodeAddress);
    }

    @NotNull
    CNodeInfoDto getOrCreateNodeRecord(@NotNull CNodeAddress aNodeAddress) {
        CNodeInfoDto result = this.mNodes.get(aNodeAddress);
        if (result == null) {
            result = new CNodeInfoDto(aNodeAddress);
            this.mNodes.put(aNodeAddress, result);
        }
        return result;
    }

    @NotNull
    CNodeInfoDto getOrCreateNodeRecord(@NotNull CNodeAddress aNodeAddress, @NotNull UUID aInstance) {
        CNodeInfoDto result = this.mNodes.get(aNodeAddress);
        if (result == null || result.getInstanceId() != null && !aInstance.equals(result.getInstanceId())) {
            result = new CNodeInfoDto(aNodeAddress, aInstance);
            this.mNodes.put(aNodeAddress, result);
        }
        return result;
    }

    public void remove(@NotNull CNodeAddress aNodeAddress) {
        this.mNodes.remove(aNodeAddress);
    }
}

