/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.address;

import de.sillysky.nyssr.exception.CUtilCheck;
import de.sillysky.nyssr.id.EIdType;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CNodeId
implements Comparable<CNodeId> {
    public static final CNodeId EMPTY = new CNodeId();
    static final AtomicReference<CNodeId> mLocalNodeId = new AtomicReference<CNodeId>(EMPTY);
    private final IId mId;
    private int mHashCode;
    private String mString;

    public CNodeId() {
        this.mId = IId.INVALID;
    }

    public CNodeId(@NotNull IId aId) {
        CUtilCheck.checkNotNull(aId, "NodeId is null", new Object[0]);
        this.mId = aId;
    }

    public CNodeId(@NotNull String aId) {
        CUtilCheck.checkNotNull(aId, "NodeId is null", new Object[0]);
        this.mId = CIdFactory.fromObject(aId);
    }

    @NotNull
    public static CNodeId fromObject(@Nullable Object aValue) {
        if (aValue instanceof CNodeId) {
            return (CNodeId)aValue;
        }
        if (aValue instanceof IId) {
            return new CNodeId((IId)aValue);
        }
        if (aValue instanceof UUID || aValue instanceof Integer) {
            IId id = CIdFactory.fromObject(aValue);
            return new CNodeId(id);
        }
        if (aValue instanceof String) {
            String value = (String)aValue;
            IId id = CIdFactory.fromObject(value);
            return new CNodeId(id);
        }
        return new CNodeId();
    }

    @NotNull
    public static CNodeId getNonNullNodeId(@Nullable CNodeId aNodeId) {
        if (aNodeId == null) {
            return EMPTY;
        }
        return aNodeId;
    }

    @NotNull
    public static CNodeId getEmpty() {
        return EMPTY;
    }

    public static boolean isEmpty(@Nullable CNodeId aNodeId) {
        return !CNodeId.isValid(aNodeId);
    }

    public static boolean isValid(@Nullable CNodeId aNodeId) {
        return aNodeId != null && aNodeId.isValid();
    }

    public static boolean equals(@Nullable CNodeId aNodeId1, @Nullable CNodeId aNodeId2) {
        if (aNodeId1 == aNodeId2) {
            return true;
        }
        if (aNodeId1 == null || EMPTY.equals(aNodeId1)) {
            return mLocalNodeId.get().equals(aNodeId2);
        }
        if (aNodeId2 == null || EMPTY.equals(aNodeId2)) {
            return mLocalNodeId.get().equals(aNodeId1);
        }
        return aNodeId1.equals(aNodeId2);
    }

    @NotNull
    public static CNodeId getLocal() {
        return mLocalNodeId.get();
    }

    public static boolean isLocal(@Nullable CNodeId aNodeId) {
        return aNodeId == null || aNodeId.isLocal();
    }

    public static void toStream(@NotNull DataOutput aStream, @Nullable CNodeId aNodeId) throws IOException {
        if (aNodeId == null) {
            aStream.writeBoolean(false);
        } else {
            aStream.writeBoolean(true);
            CIdFactory.toStream(aStream, aNodeId.mId);
        }
    }

    @Nullable
    public static CNodeId fromStream(@NotNull DataInput aStream) throws IOException {
        boolean valid = aStream.readBoolean();
        if (valid) {
            IId id = CIdFactory.fromStream(aStream, true);
            return new CNodeId(id == null ? IId.INVALID : id);
        }
        return null;
    }

    @NotNull
    public static String toString(@Nullable CNodeId aValue) {
        return aValue == null ? "null" : aValue.valueToString();
    }

    public static String valueToString(@Nullable CNodeId aValue) {
        return aValue == null ? "null" : aValue.valueToString();
    }

    @NotNull
    public static CNodeId random() {
        return new CNodeId(CIdFactory.randomOfType(EIdType.INT));
    }

    @Override
    public int compareTo(@NotNull CNodeId aOther) {
        return CIdFactory.compareTo(this.mId, aOther.getId());
    }

    private void createStrings() {
        if (this.mString == null) {
            this.mString = this.mId.valueToString();
            this.mHashCode = Objects.hash(this.mId);
        }
    }

    public boolean equals(@Nullable Object aOther) {
        if (this == aOther) {
            return true;
        }
        if (aOther == null || this.getClass() != aOther.getClass()) {
            return false;
        }
        CNodeId nodeId = (CNodeId)aOther;
        return this.mId.equals(nodeId.mId);
    }

    @NotNull
    public IId getId() {
        return this.mId;
    }

    public int hashCode() {
        this.createStrings();
        return this.mHashCode;
    }

    public boolean isValid() {
        return CIdFactory.isValid(this.mId);
    }

    public boolean isEmpty() {
        return CIdFactory.isEmpty(this.mId);
    }

    public String toString() {
        this.createStrings();
        return this.mString;
    }

    @NotNull
    public String valueToString() {
        this.createStrings();
        return this.mString;
    }

    public boolean isLocal() {
        return this.equals(EMPTY) || this.equals(mLocalNodeId.get());
    }

    public static void setLocal(@NotNull CNodeId aNodeId) {
        CUtilCheck.checkNotNull(aNodeId, "Local Node ID can't be null", new Object[0]);
        mLocalNodeId.set(aNodeId);
    }
}

