/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.configuration.files.records;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.record.IGeneratedRecord;
import de.sillysky.nyssr.slot.CCommonSlotType;
import de.sillysky.nyssr.slot.CSlotFactoryHelper;
import de.sillysky.nyssr.slot.ISlot;
import org.jetbrains.annotations.NotNull;

public final class CRecordDeletePreference
implements IGeneratedRecord {
    public static final IId ID = CIdFactory.fromObject("40fabb16-02f1-4b91-b14a-5f463c68f991");
    public static final String NAME = "DeletePreference";
    public static final String DESCRIPTION = "Delete a local preference key or node for a given node.";
    public static final String SLOT_KEY = "1";
    public static final String[] NAMESPACES = new String[]{"SYSTEM"};
    public static final boolean IS_NANO_SERVICE = true;

    @NotNull
    public static CRecord create() {
        return new CRecord(ID);
    }

    public static String getKey(@NotNull CRecord aRecord, String aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_KEY);
        if (slot == null) {
            return aDefault;
        }
        return (String)slot.getValue();
    }

    public static void setKey(@NotNull CRecord aRecord, String aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject(CCommonSlotType.STRING, aValue);
        aRecord.addSlot(SLOT_KEY, slot);
    }
}

