/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.configuration.files.records;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.record.IGeneratedRecord;
import de.sillysky.nyssr.slot.CCommonSlotType;
import de.sillysky.nyssr.slot.CSlotFactoryHelper;
import de.sillysky.nyssr.slot.ISlot;
import org.jetbrains.annotations.NotNull;

public final class CRecordGetPreference
implements IGeneratedRecord {
    public static final IId ID = CIdFactory.fromObject("768b6c7d-6d8d-403a-bf37-277962eba622");
    public static final String NAME = "GetPreference";
    public static final String DESCRIPTION = "Get a local preference value for a given node.";
    public static final String SLOT_KEY = "1";
    public static final String SLOT_VALUE = "10";
    public static final String[] NAMESPACES = new String[]{"SYSTEM"};
    public static final boolean IS_NANO_SERVICE = true;

    @NotNull
    public static CRecord create() {
        return new CRecord(ID);
    }

    public static String getKey(@NotNull CRecord aRecord, String aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_KEY);
        if (slot == null) {
            return aDefault;
        }
        return (String)slot.getValue();
    }

    public static String getValue(@NotNull CRecord aRecord, String aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_VALUE);
        if (slot == null) {
            return aDefault;
        }
        return (String)slot.getValue();
    }

    public static void setKey(@NotNull CRecord aRecord, String aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject(CCommonSlotType.STRING, aValue);
        aRecord.addSlot(SLOT_KEY, slot);
    }

    public static void setValue(@NotNull CRecord aRecord, String aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject(CCommonSlotType.STRING, aValue);
        aRecord.addSlot(SLOT_VALUE, slot);
    }
}

