/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.hsm;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.hsm.IHsm;
import de.sillysky.nyssr.hsm.IHsmState;
import de.sillysky.nyssr.hsm.records.CRecordEnterHsmState;
import de.sillysky.nyssr.hsm.records.CRecordLeaveHsmState;
import de.sillysky.nyssr.hsm.records.CRecordStartHsmState;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.hsm.CHsmFactory;
import de.sillysky.nyssr.impl.hsm.CHsmState;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.message.CMessage;
import de.sillysky.nyssr.record.CRecord;
import java.util.HashMap;
import java.util.LinkedList;

class CHsm
implements IHsm {
    private static final ILogger LOG = CLoggerFactory.getLogger(CHsm.class);
    private static final int INITIAL_LENGTH = 20;
    private final String mName;
    private final HashMap<String, IHsmState> mStates;
    private final CHsmFactory mFactory;
    private final Object mOwnerOrLogger;
    private IHsmState mCurrentState = null;
    private IHsmState mPreviousState = null;
    private IHsmState mTopState = null;
    private IHsmState mNextState = null;
    private boolean mVerbose = true;
    private CEnvelope mLastEnvelope = null;
    private CRecord mLastRecord = null;

    CHsm(CHsmFactory aFactory, String aName, Object aOwnerOrLogger) {
        this.mFactory = aFactory;
        this.mName = aName;
        this.mOwnerOrLogger = aOwnerOrLogger;
        this.mStates = new HashMap(20);
    }

    @Override
    public IHsmState addChildState(String aName, IHsmState aParentState) {
        CHsmState state = new CHsmState(this.mFactory, this, aParentState, aName);
        this.addState(state);
        return state;
    }

    @Override
    public IHsmState addChildState(String aName, String aParentStateName) {
        if (aParentStateName == null || aParentStateName.isEmpty()) {
            LOG.error("HSM {} State {}: Parent state is null.", this.mName, aName);
            return null;
        }
        IHsmState parent = this.getStateByName(aParentStateName);
        if (parent == null) {
            LOG.error("HSM {} State {}: Could not find parent state {}", this.mName, aName, aParentStateName);
            return null;
        }
        CHsmState state = new CHsmState(this.mFactory, this, parent, aName);
        this.addState(state);
        return state;
    }

    private synchronized void addState(IHsmState aState) {
        this.mStates.put(aState.getStateName(), aState);
    }

    @Override
    public IHsmState addTopState(String aName) {
        CHsmState state = new CHsmState(this.mFactory, this, null, aName);
        this.addState(state);
        return state;
    }

    @Override
    public final synchronized IHsmState getCurrentState() {
        return this.mCurrentState;
    }

    @Override
    public final String getHsmName() {
        return this.mName;
    }

    @Override
    public final synchronized CEnvelope getLastEnvelope() {
        return this.mLastEnvelope;
    }

    @Override
    public final synchronized CRecord getLastRecord() {
        return this.mLastRecord;
    }

    @Override
    public Object getOwnerOrLogger() {
        return this.mOwnerOrLogger;
    }

    @Override
    public final synchronized IHsmState getPreviousCurrentState() {
        return this.mPreviousState;
    }

    @Override
    public final IHsmState getStateByName(String aName) {
        return this.mStates.get(aName);
    }

    @Override
    public final synchronized IHsmState[] getStates() {
        IHsmState[] arr = new IHsmState[this.mStates.size()];
        arr = this.mStates.values().toArray(arr);
        return arr;
    }

    @Override
    public final synchronized void handleHsmMessage(CMessage aMsg) throws Exception {
        CRecord record;
        CEnvelope env = aMsg.getEnvelope();
        this.mLastRecord = record = aMsg.getRecord();
        this.mLastEnvelope = env;
        try {
            for (IHsmState s = this.mCurrentState; s != null; s = s.getParentState()) {
                if (!this.internalTrigger(s, env, record)) continue;
                while (this.mNextState != null) {
                    this.internalTransition();
                }
                break;
            }
        }
        catch (Exception e) {
            if (this.mNextState != null) {
                if (this.mNextState == this.mTopState || this.isChildState(this.mTopState, this.mNextState)) {
                    this.mCurrentState = this.mNextState;
                }
                this.mNextState = null;
            }
            throw e;
        }
        this.mLastEnvelope = null;
        this.mLastRecord = null;
    }

    private void internalLogException(IHsmState aState, Throwable aT) {
        StringBuilder sb = new StringBuilder(400);
        sb.append("Exception in HSM=");
        sb.append(this.mName);
        sb.append(" State=");
        sb.append(aState == null ? "null" : aState.getStateName());
        sb.append(" Envelope=");
        sb.append(this.mLastEnvelope == null ? "null" : this.mLastEnvelope.toString());
        sb.append(" Record=");
        sb.append(this.mLastRecord == null ? "null" : this.mLastRecord.toString());
        sb.append(" Throwable=");
        sb.append(aT);
        LOG.error(aT, sb.toString());
    }

    private void internalStateEntry(IHsmState aState) {
        try {
            this.logText(aState, "ENTRY");
            aState.handleMessage(this, new CEnvelope(), CRecordEnterHsmState.create());
        }
        catch (Exception e) {
            this.internalLogException(aState, e);
        }
    }

    private void internalStateExit(IHsmState aState) {
        try {
            this.logText(aState, "EXIT");
            aState.handleMessage(this, new CEnvelope(), CRecordLeaveHsmState.create());
        }
        catch (Exception e) {
            this.internalLogException(aState, e);
        }
    }

    private void internalStateStart(IHsmState aState) {
        try {
            this.logText(aState, "START");
            aState.handleMessage(this, new CEnvelope(), CRecordStartHsmState.create());
        }
        catch (Exception e) {
            this.internalLogException(aState, e);
        }
    }

    private void internalTransition() {
        if (this.mNextState == this.mCurrentState) {
            this.internalStateExit(this.mCurrentState);
            this.internalStateEntry(this.mCurrentState);
        } else {
            IHsmState tempState;
            IHsmState lcaState = this.mCurrentState;
            block0: for (tempState = this.mCurrentState; tempState != null; tempState = tempState.getParentState()) {
                for (IHsmState t = this.mNextState; t != null; t = t.getParentState()) {
                    if (tempState != t) continue;
                    lcaState = tempState;
                    break block0;
                }
            }
            for (tempState = this.mCurrentState; tempState != lcaState; tempState = tempState.getParentState()) {
                this.internalStateExit(tempState);
            }
            LinkedList<IHsmState> list = new LinkedList<IHsmState>();
            for (tempState = this.mNextState; tempState != lcaState; tempState = tempState.getParentState()) {
                list.addFirst(tempState);
            }
            for (IHsmState state : list) {
                this.internalStateEntry(state);
            }
            this.mPreviousState = this.mCurrentState;
            this.mCurrentState = this.mNextState;
        }
        this.mNextState = null;
        this.internalStateStart(this.mCurrentState);
    }

    private boolean internalTrigger(IHsmState aState, CEnvelope aEnvelope, CRecord aRecord) throws Exception {
        IId id;
        boolean handled = false;
        if (aEnvelope != null && aRecord != null && (id = aRecord.getId()) != null) {
            if (!this.mVerbose) {
                this.logText(aState, aEnvelope, aRecord);
            }
            try {
                handled = aState.handleMessage(this, aEnvelope, aRecord);
            }
            catch (Exception e) {
                this.internalLogException(aState, e);
                throw e;
            }
        }
        return handled;
    }

    @Override
    public final synchronized boolean isChildState(IHsmState aStateToCheck, IHsmState aChildState) {
        try {
            for (IHsmState s = aChildState; s != null; s = s.getParentState()) {
                if (s != aStateToCheck) continue;
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    @Override
    public final synchronized boolean isStateActive(IHsmState aState) {
        return this.isChildState(aState, this.mCurrentState);
    }

    @Override
    public final boolean isVerbose() {
        return this.mVerbose;
    }

    @Override
    public final void setVerbose(boolean aVerbose) {
        this.mVerbose = aVerbose;
    }

    private void logText(IHsmState aState, CEnvelope aEnvelope, CRecord aRecord) {
        if (this.mVerbose && LOG.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder(400);
            sb.append("HSM=");
            sb.append(this.mName);
            sb.append(" State=");
            sb.append(aState == null ? "null" : aState.getStateName());
            sb.append(" Envelope=");
            sb.append(aEnvelope == null ? "null" : aEnvelope.toString());
            sb.append(" Record=");
            sb.append(aRecord == null ? "null" : aRecord.toString());
            LOG.debug(sb.toString());
        }
    }

    private void logText(IHsmState aState, String aText) {
        if (this.mVerbose && LOG.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder(400);
            sb.append("HSM=");
            sb.append(this.mName);
            sb.append(" State=");
            sb.append(aState == null ? "null" : aState.getStateName());
            sb.append(" ");
            sb.append(aText);
            LOG.debug(sb.toString());
        }
    }

    @Override
    public final synchronized void startHSM(IHsmState aTopState) {
        this.mTopState = aTopState;
        try {
            this.startHSMInternal();
        }
        catch (Exception e) {
            LOG.error(e, "Exception on startHsm, top state is {}.", aTopState.toString());
        }
    }

    @Override
    public final synchronized void startHSM(String aNameOfTopState) {
        this.mTopState = this.getStateByName(aNameOfTopState);
        try {
            this.startHSMInternal();
        }
        catch (Exception e) {
            LOG.error(e, "Exception on startHsm, top state is {}.", aNameOfTopState);
        }
    }

    private void startHSMInternal() throws Exception {
        if (this.mTopState == null) {
            throw new CException(25).append("TopState is null.");
        }
        this.mCurrentState = this.mTopState;
        this.mNextState = null;
        this.internalStateEntry(this.mCurrentState);
        this.internalStateStart(this.mCurrentState);
        while (this.mNextState != null) {
            this.internalTransition();
        }
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder(100);
        sb.append("HSM ");
        sb.append(this.mName);
        sb.append("[currentState=");
        if (this.mCurrentState == null) {
            sb.append("null");
        } else {
            sb.append(this.mCurrentState.getStateName());
        }
        sb.append(']');
        return sb.toString();
    }

    @Override
    public final synchronized void transitionToState(IHsmState aTarget) throws Exception {
        if (this.mNextState != null) {
            throw new CException(20).append("nextState != null");
        }
        if (!this.mStates.containsKey(aTarget.getStateName())) {
            throw new CException(25).append("Destination state <").append(aTarget.getStateName()).append(">not registered in HSM: Use IHsm.addState().");
        }
        this.mNextState = aTarget;
    }

    @Override
    public final void transitionToState(String aStateName) throws Exception {
        IHsmState state = this.getStateByName(aStateName);
        if (state == null) {
            throw new CException(25).append("Unknown state ").append(aStateName);
        }
        this.transitionToState(state);
    }
}

