/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.log;

import de.sillysky.nyssr.impl.log.CLogMachine;
import de.sillysky.nyssr.log.CDefaultMessageFormatter;
import de.sillysky.nyssr.log.CLogDto;
import de.sillysky.nyssr.log.ELevel;
import de.sillysky.nyssr.log.ILogger;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CLogger
implements ILogger {
    private static final int STACK_DEPTH = 3;
    private final CLogMachine mLogMachine;
    private final String mName;
    private final Class<?> mClass;
    private ELevel mLevel;
    private static final AtomicInteger INDEX = new AtomicInteger(0);

    CLogger(@NotNull CLogMachine aLogMachine, @NotNull String aName) {
        this.mLogMachine = aLogMachine;
        this.mName = aName;
        this.mClass = null;
    }

    CLogger(@NotNull CLogMachine aLogMachine, @NotNull Class<?> aClass) {
        this.mLogMachine = aLogMachine;
        this.mName = null;
        this.mClass = aClass;
    }

    @Override
    public boolean canLog(ELevel aLevel) {
        int theirs;
        int mine = this.mLevel.ordinal();
        return mine <= (theirs = aLevel.ordinal());
    }

    @Override
    public void debug(@NotNull String aMessage) {
        if (this.canLog(ELevel.DEBUG)) {
            CLogDto dto = new CLogDto(ELevel.DEBUG, INDEX.incrementAndGet(), this.mClass, this.mName);
            dto.setMessage(aMessage);
            this.mLogMachine.log(3, dto);
        }
    }

    @Override
    public void debug(@NotNull Properties aProperties, @NotNull String aMessage) {
        if (this.canLog(ELevel.DEBUG)) {
            CLogDto dto = new CLogDto(ELevel.DEBUG, INDEX.incrementAndGet(), this.mClass, this.mName);
            dto.setProperties(aProperties);
            dto.setMessage(aMessage);
            this.mLogMachine.log(3, dto);
        }
    }

    @Override
    public void debug(@NotNull Supplier<?> aSupplier) {
        if (this.canLog(ELevel.DEBUG)) {
            CLogDto dto = new CLogDto(ELevel.DEBUG, INDEX.incrementAndGet(), this.mClass, this.mName);
            dto.setSupplier(aSupplier);
            this.mLogMachine.log(3, dto);
        }
    }

    @Override
    public void debug(@NotNull Properties aProperties, @NotNull Supplier<?> aSupplier) {
        if (this.canLog(ELevel.DEBUG)) {
            CLogDto dto = new CLogDto(ELevel.DEBUG, INDEX.incrementAndGet(), this.mClass, this.mName);
            dto.setProperties(aProperties);
            dto.setSupplier(aSupplier);
            this.mLogMachine.log(3, dto);
        }
    }

    @Override
    public void debug(@NotNull String aMessage, Object ... aArguments) {
        if (this.canLog(ELevel.DEBUG)) {
            CLogDto dto = new CLogDto(ELevel.DEBUG, INDEX.incrementAndGet(), this.mClass, this.mName);
            dto.setMessage(aMessage);
            dto.setArguments(aArguments);
            this.mLogMachine.log(3, dto);
        }
    }

    @Override
    public void debug(@NotNull Properties aProperties, @NotNull String aMessage, Object ... aArguments) {
        if (this.canLog(ELevel.DEBUG)) {
            CLogDto dto = new CLogDto(ELevel.DEBUG, INDEX.incrementAndGet(), this.mClass, this.mName);
            dto.setProperties(aProperties);
            dto.setMessage(aMessage);
            dto.setArguments(aArguments);
            this.mLogMachine.log(3, dto);
        }
    }

    @Override
    public void error(@NotNull String aMessage) {
        if (this.canLog(ELevel.ERROR)) {
            CLogDto dto = new CLogDto(ELevel.ERROR, INDEX.incrementAndGet(), this.mClass, this.mName);
            dto.setMessage(aMessage);
            this.errorLogged(dto);
            this.mLogMachine.log(3, dto);
        }
    }

    @Override
    public void error(@NotNull String aMessage, int aStackDepthToAdd) {
        if (this.canLog(ELevel.ERROR)) {
            CLogDto dto = new CLogDto(ELevel.ERROR, INDEX.incrementAndGet(), this.mClass, this.mName);
            dto.setMessage(aMessage);
            this.errorLogged(dto);
            this.mLogMachine.log(3 + aStackDepthToAdd, dto);
        }
    }

    @Override
    public void error(@NotNull Properties aProperties, @NotNull String aMessage) {
        if (this.canLog(ELevel.ERROR)) {
            CLogDto dto = new CLogDto(ELevel.ERROR, INDEX.incrementAndGet(), this.mClass, this.mName);
            dto.setProperties(aProperties);
            dto.setMessage(aMessage);
            this.errorLogged(dto);
            this.mLogMachine.log(3, dto);
        }
    }

    @Override
    public void error(@NotNull Supplier<?> aSupplier) {
        if (this.canLog(ELevel.ERROR)) {
            CLogDto dto = new CLogDto(ELevel.ERROR, INDEX.incrementAndGet(), this.mClass, this.mName);
            dto.setSupplier(aSupplier);
            this.errorLogged(dto);
            this.mLogMachine.log(3, dto);
        }
    }

    @Override
    public void error(@NotNull Properties aProperties, @NotNull Supplier<?> aSupplier) {
        if (this.canLog(ELevel.ERROR)) {
            CLogDto dto = new CLogDto(ELevel.ERROR, INDEX.incrementAndGet(), this.mClass, this.mName);
            dto.setProperties(aProperties);
            dto.setSupplier(aSupplier);
            this.errorLogged(dto);
            this.mLogMachine.log(3, dto);
        }
    }

    @Override
    public void error(@NotNull String aMessage, Object ... aArguments) {
        if (this.canLog(ELevel.ERROR)) {
            CLogDto dto = new CLogDto(ELevel.ERROR, INDEX.incrementAndGet(), this.mClass, this.mName);
            dto.setMessage(aMessage);
            dto.setArguments(aArguments);
            this.errorLogged(dto);
            this.mLogMachine.log(3, dto);
        }
    }

    @Override
    public void error(@NotNull Properties aProperties, @NotNull String aMessage, Object ... aArguments) {
        if (this.canLog(ELevel.ERROR)) {
            CLogDto dto = new CLogDto(ELevel.ERROR, INDEX.incrementAndGet(), this.mClass, this.mName);
            dto.setProperties(aProperties);
            dto.setMessage(aMessage);
            dto.setArguments(aArguments);
            this.errorLogged(dto);
            this.mLogMachine.log(3, dto);
        }
    }

    @Override
    public void error(@NotNull Throwable aThrowable) {
        if (this.canLog(ELevel.ERROR)) {
            CLogDto dto = new CLogDto(ELevel.ERROR, INDEX.incrementAndGet(), this.mClass, this.mName);
            dto.setThrowable(aThrowable);
            this.errorLogged(dto);
            this.mLogMachine.log(3, dto);
        }
    }

    @Override
    public void error(@NotNull Properties aProperties, @NotNull Throwable aThrowable) {
        if (this.canLog(ELevel.ERROR)) {
            CLogDto dto = new CLogDto(ELevel.ERROR, INDEX.incrementAndGet(), this.mClass, this.mName);
            dto.setProperties(aProperties);
            dto.setThrowable(aThrowable);
            this.errorLogged(dto);
            this.mLogMachine.log(3, dto);
        }
    }

    @Override
    public void error(@NotNull Throwable aThrowable, @NotNull String aMessage) {
        if (this.canLog(ELevel.ERROR)) {
            CLogDto dto = new CLogDto(ELevel.ERROR, INDEX.incrementAndGet(), this.mClass, this.mName);
            dto.setThrowable(aThrowable);
            dto.setMessage(aMessage);
            this.errorLogged(dto);
            this.mLogMachine.log(3, dto);
        }
    }

    @Override
    public void error(@NotNull Properties aProperties, @NotNull Throwable aThrowable, @NotNull String aMessage) {
        if (this.canLog(ELevel.ERROR)) {
            CLogDto dto = new CLogDto(ELevel.ERROR, INDEX.incrementAndGet(), this.mClass, this.mName);
            dto.setProperties(aProperties);
            dto.setThrowable(aThrowable);
            dto.setMessage(aMessage);
            this.errorLogged(dto);
            this.mLogMachine.log(3, dto);
        }
    }

    @Override
    public void error(@NotNull Throwable aThrowable, @NotNull String aMessage, Object ... aArguments) {
        if (this.canLog(ELevel.ERROR)) {
            CLogDto dto = new CLogDto(ELevel.ERROR, INDEX.incrementAndGet(), this.mClass, this.mName);
            dto.setThrowable(aThrowable);
            dto.setMessage(aMessage);
            dto.setArguments(aArguments);
            this.errorLogged(dto);
            this.mLogMachine.log(3, dto);
        }
    }

    @Override
    public void error(@NotNull Properties aProperties, @NotNull Throwable aThrowable, @NotNull String aMessage, Object ... aArguments) {
        if (this.canLog(ELevel.ERROR)) {
            CLogDto dto = new CLogDto(ELevel.ERROR, INDEX.incrementAndGet(), this.mClass, this.mName);
            dto.setProperties(aProperties);
            dto.setThrowable(aThrowable);
            dto.setMessage(aMessage);
            dto.setArguments(aArguments);
            this.errorLogged(dto);
            this.mLogMachine.log(3, dto);
        }
    }

    @Override
    public void error(@NotNull Throwable aThrowable, @NotNull Supplier<?> aSupplier) {
        if (this.canLog(ELevel.ERROR)) {
            CLogDto dto = new CLogDto(ELevel.ERROR, INDEX.incrementAndGet(), this.mClass, this.mName);
            dto.setThrowable(aThrowable);
            dto.setSupplier(aSupplier);
            this.errorLogged(dto);
            this.mLogMachine.log(3, dto);
        }
    }

    @Override
    public void error(@NotNull Properties aProperties, @NotNull Throwable aThrowable, @NotNull Supplier<?> aSupplier) {
        if (this.canLog(ELevel.ERROR)) {
            CLogDto dto = new CLogDto(ELevel.ERROR, INDEX.incrementAndGet(), this.mClass, this.mName);
            dto.setProperties(aProperties);
            dto.setThrowable(aThrowable);
            dto.setSupplier(aSupplier);
            this.errorLogged(dto);
            this.mLogMachine.log(3, dto);
        }
    }

    @Override
    public ELevel getLevel() {
        return this.mLevel;
    }

    void setLevel(ELevel aLevel) {
        this.mLevel = aLevel;
    }

    Class<?> getLoggerClass() {
        return this.mClass;
    }

    String getName() {
        return this.mName;
    }

    @Override
    public void info(@NotNull String aMessage) {
        if (this.canLog(ELevel.INFO)) {
            CLogDto dto = new CLogDto(ELevel.INFO, INDEX.incrementAndGet(), this.mClass, this.mName);
            dto.setMessage(aMessage);
            this.mLogMachine.log(3, dto);
        }
    }

    @Override
    public void info(@NotNull Properties aProperties, @NotNull String aMessage) {
        if (this.canLog(ELevel.INFO)) {
            CLogDto dto = new CLogDto(ELevel.INFO, INDEX.incrementAndGet(), this.mClass, this.mName);
            dto.setProperties(aProperties);
            dto.setMessage(aMessage);
            this.mLogMachine.log(3, dto);
        }
    }

    @Override
    public void info(@NotNull Supplier<?> aSupplier) {
        if (this.canLog(ELevel.INFO)) {
            CLogDto dto = new CLogDto(ELevel.INFO, INDEX.incrementAndGet(), this.mClass, this.mName);
            dto.setSupplier(aSupplier);
            this.mLogMachine.log(3, dto);
        }
    }

    @Override
    public void info(@NotNull Properties aProperties, @NotNull Supplier<?> aSupplier) {
        if (this.canLog(ELevel.INFO)) {
            CLogDto dto = new CLogDto(ELevel.INFO, INDEX.incrementAndGet(), this.mClass, this.mName);
            dto.setProperties(aProperties);
            dto.setSupplier(aSupplier);
            this.mLogMachine.log(3, dto);
        }
    }

    @Override
    public void info(@NotNull String aMessage, Object ... aArguments) {
        if (this.canLog(ELevel.INFO)) {
            CLogDto dto = new CLogDto(ELevel.INFO, INDEX.incrementAndGet(), this.mClass, this.mName);
            dto.setMessage(aMessage);
            dto.setArguments(aArguments);
            this.mLogMachine.log(3, dto);
        }
    }

    @Override
    public void info(@NotNull Properties aProperties, @NotNull String aMessage, Object ... aArguments) {
        if (this.canLog(ELevel.INFO)) {
            CLogDto dto = new CLogDto(ELevel.INFO, INDEX.incrementAndGet(), this.mClass, this.mName);
            dto.setProperties(aProperties);
            dto.setMessage(aMessage);
            dto.setArguments(aArguments);
            this.mLogMachine.log(3, dto);
        }
    }

    @Override
    public boolean isDebugEnabled() {
        return this.canLog(ELevel.DEBUG);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.canLog(ELevel.ERROR);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.canLog(ELevel.INFO);
    }

    @Override
    public boolean isTraceEnabled() {
        return this.canLog(ELevel.TRACE);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.canLog(ELevel.WARN);
    }

    @Override
    public void trace(@NotNull String aMessage) {
        if (this.canLog(ELevel.TRACE)) {
            CLogDto dto = new CLogDto(ELevel.TRACE, INDEX.incrementAndGet(), this.mClass, this.mName);
            dto.setMessage(aMessage);
            this.mLogMachine.log(3, dto);
        }
    }

    @Override
    public void trace(@NotNull Properties aProperties, @NotNull String aMessage) {
        if (this.canLog(ELevel.TRACE)) {
            CLogDto dto = new CLogDto(ELevel.TRACE, INDEX.incrementAndGet(), this.mClass, this.mName);
            dto.setProperties(aProperties);
            dto.setMessage(aMessage);
            this.mLogMachine.log(3, dto);
        }
    }

    @Override
    public void trace(@NotNull Supplier<?> aSupplier) {
        if (this.canLog(ELevel.TRACE)) {
            CLogDto dto = new CLogDto(ELevel.TRACE, INDEX.incrementAndGet(), this.mClass, this.mName);
            dto.setSupplier(aSupplier);
            this.mLogMachine.log(3, dto);
        }
    }

    @Override
    public void trace(@NotNull Properties aProperties, @NotNull Supplier<?> aSupplier) {
        if (this.canLog(ELevel.TRACE)) {
            CLogDto dto = new CLogDto(ELevel.TRACE, INDEX.incrementAndGet(), this.mClass, this.mName);
            dto.setProperties(aProperties);
            dto.setSupplier(aSupplier);
            this.mLogMachine.log(3, dto);
        }
    }

    @Override
    public void trace(@NotNull String aMessage, Object ... aArguments) {
        if (this.canLog(ELevel.TRACE)) {
            CLogDto dto = new CLogDto(ELevel.TRACE, INDEX.incrementAndGet(), this.mClass, this.mName);
            dto.setMessage(aMessage);
            dto.setArguments(aArguments);
            this.mLogMachine.log(3, dto);
        }
    }

    @Override
    public void trace(@NotNull Properties aProperties, @NotNull String aMessage, Object ... aArguments) {
        if (this.canLog(ELevel.TRACE)) {
            CLogDto dto = new CLogDto(ELevel.TRACE, INDEX.incrementAndGet(), this.mClass, this.mName);
            dto.setProperties(aProperties);
            dto.setMessage(aMessage);
            dto.setArguments(aArguments);
            this.mLogMachine.log(3, dto);
        }
    }

    @Override
    public void warn(@NotNull String aMessage) {
        if (this.canLog(ELevel.WARN)) {
            CLogDto dto = new CLogDto(ELevel.WARN, INDEX.incrementAndGet(), this.mClass, this.mName);
            dto.setMessage(aMessage);
            this.mLogMachine.log(3, dto);
        }
    }

    @Override
    public void warn(@NotNull Properties aProperties, @NotNull String aMessage) {
        if (this.canLog(ELevel.WARN)) {
            CLogDto dto = new CLogDto(ELevel.WARN, INDEX.incrementAndGet(), this.mClass, this.mName);
            dto.setProperties(aProperties);
            dto.setMessage(aMessage);
            this.mLogMachine.log(3, dto);
        }
    }

    @Override
    public void warn(@NotNull Supplier<?> aSupplier) {
        if (this.canLog(ELevel.WARN)) {
            CLogDto dto = new CLogDto(ELevel.WARN, INDEX.incrementAndGet(), this.mClass, this.mName);
            dto.setSupplier(aSupplier);
            this.mLogMachine.log(3, dto);
        }
    }

    @Override
    public void warn(@NotNull Properties aProperties, @NotNull Supplier<?> aSupplier) {
        if (this.canLog(ELevel.WARN)) {
            CLogDto dto = new CLogDto(ELevel.WARN, INDEX.incrementAndGet(), this.mClass, this.mName);
            dto.setProperties(aProperties);
            dto.setSupplier(aSupplier);
            this.mLogMachine.log(3, dto);
        }
    }

    @Override
    public void warn(@NotNull String aMessage, Object ... aArguments) {
        if (this.canLog(ELevel.WARN)) {
            CLogDto dto = new CLogDto(ELevel.WARN, INDEX.incrementAndGet(), this.mClass, this.mName);
            dto.setMessage(aMessage);
            dto.setArguments(aArguments);
            this.mLogMachine.log(3, dto);
        }
    }

    @Override
    public void warn(@NotNull Properties aProperties, @NotNull String aMessage, Object ... aArguments) {
        if (this.canLog(ELevel.WARN)) {
            CLogDto dto = new CLogDto(ELevel.WARN, INDEX.incrementAndGet(), this.mClass, this.mName);
            dto.setProperties(aProperties);
            dto.setMessage(aMessage);
            dto.setArguments(aArguments);
            this.mLogMachine.log(3, dto);
        }
    }

    @Override
    public void logOnConsole(@NotNull String aMessage, Object ... aArguments) {
        CLogDto dto = new CLogDto(ELevel.INFO, INDEX.incrementAndGet(), this.mClass, this.mName);
        dto.setMessage(aMessage);
        dto.setArguments(aArguments);
        String message = new CDefaultMessageFormatter().format(dto);
        System.out.println(message);
    }

    private void errorLogged(@Nullable CLogDto dto) {
        assert (dto != null);
    }
}

