/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.nanoservice;

import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.exception.CUtilCheck;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.impl.nanoservice.CNanoServiceEntry;
import de.sillysky.nyssr.impl.nanoservice.monitor.CNanoServiceMonitor;
import de.sillysky.nyssr.impl.service.CServiceRegistry;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.message.CMessage;
import de.sillysky.nyssr.message.IMessageSender;
import de.sillysky.nyssr.message.hook.IMessageHookRegistry;
import de.sillysky.nyssr.namedb.INameDb;
import de.sillysky.nyssr.nanoservice.INanoServiceMonitor;
import de.sillysky.nyssr.nanoservice.INanoServiceRegistry;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.record.IGeneratedRecord;
import de.sillysky.nyssr.target.listener.IListenerRegistry;
import de.sillysky.nyssr.util.CUtilString;
import de.sillysky.nyssr.util.properties.CStringProperties;
import java.lang.reflect.Field;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CNanoServiceRegistry
implements INanoServiceRegistry {
    private static final ILogger LOG = CLoggerFactory.getLogger(CNanoServiceRegistry.class);
    @NotNull
    private final HashMap<IId, CNanoServiceEntry> mServices = new HashMap();
    @NotNull
    private final IId mNID;
    @NotNull
    private final IListenerRegistry mListenerRegistry;
    @NotNull
    private final IMessageHookRegistry mMessageHookRegistry;
    @NotNull
    private final INameDb mNameDb;
    @NotNull
    private final CNanoServiceMonitor mMonitor;
    @NotNull
    private final IMessageSender mMessageSender;

    CNanoServiceRegistry(@NotNull IId aNID, @NotNull IMessageSender aMessageSender, @NotNull IListenerRegistry aListenerRegistry, @NotNull IMessageHookRegistry aMessageHookRegistry, @NotNull INameDb aNameDb) {
        this.mNID = aNID;
        this.mMessageSender = aMessageSender;
        this.mListenerRegistry = aListenerRegistry;
        this.mMessageHookRegistry = aMessageHookRegistry;
        this.mNameDb = aNameDb;
        this.mMonitor = new CNanoServiceMonitor(aNID, this.mMessageSender, this.mListenerRegistry);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Activate {} {}", this.getClass().getSimpleName(), System.identityHashCode(this));
        }
    }

    @Override
    public void addObserver(@NotNull IId aSID, @NotNull CTargetAddress aAddress) throws CException {
        this.addObserverInternally(aSID, aAddress, false);
    }

    @Override
    public void addObserver(@NotNull IId aSID, @NotNull CTargetAddress aAddress, boolean aSendLast) throws CException {
        this.addObserverInternally(aSID, aAddress, aSendLast);
    }

    @Override
    public void addObserver(@NotNull Class<? extends IGeneratedRecord> aClass, @NotNull CTargetAddress aAddress, boolean aSendLast) throws CException {
        CUtilCheck.checkNotNull(aClass, "Missing Class", new Object[0]);
        CUtilCheck.checkNotNull(aAddress, "Missing Observer Address", new Object[0]);
        try {
            Field f = aClass.getDeclaredField("ID");
            IId id = (IId)f.get(null);
            this.addNanoService(aClass);
            this.addObserver(id, aAddress, aSendLast);
        }
        catch (Exception aE) {
            LOG.error(aE, "Couldn't get namespace for NanoService {}.", aClass.getName());
            throw new CException(29).append(aE.getMessage());
        }
    }

    private void addObserverInternally(IId aSID, CTargetAddress aAddress, boolean aRecallTrigger) throws CException {
        String action = "addObservers";
        this.checkSID(aSID, "addObservers");
        this.checkAddress(aAddress, "addObservers");
        CNanoServiceEntry se = this.ensureSid(aSID);
        se.addObserver(aAddress, aRecallTrigger);
        this.mMonitor.triggerObserverAdded(se.getID(), se.getName(), aAddress);
    }

    @Override
    public void addObservers(@NotNull IId[] aSID, @NotNull CTargetAddress aAddress) throws CException {
        for (IId element : aSID) {
            this.addObserver(element, aAddress, false);
        }
    }

    @Override
    public void addObservers(@NotNull IId[] aSID, @NotNull CTargetAddress aAddress, boolean aSendLast) throws CException {
        for (IId element : aSID) {
            this.addObserver(element, aAddress, aSendLast);
        }
    }

    private void checkAddress(CTargetAddress aAddress, String aAction) throws CException {
        if (aAddress == null || !aAddress.getTID().isValid()) {
            LOG.error("{}: Error because of invalid ADDRESS", aAction);
            throw new CException(2505).append(LOG.toString());
        }
    }

    private void checkSID(IId aSID, String aAction) throws CException {
        if (!CIdFactory.isValid(aSID)) {
            LOG.error("{}: Error because of SID=null", aAction);
            throw new CException(2303).append(LOG.toString());
        }
    }

    @Override
    public void deactivate() {
        CServiceRegistry.getInstance().deregisterService(this);
    }

    @Override
    public void removeNanoService(@NotNull IId aSID) throws CException {
        String action = "deregisterService";
        this.checkSID(aSID, "deregisterService");
        CNanoServiceEntry se = this.getServiceEntryEx(aSID);
        this.mServices.remove(aSID);
        this.mMonitor.triggerServiceDeregistered(se.getID(), se.getName());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Deregister NanoService <{}>.", this.getServiceString(se));
        }
    }

    @Override
    public void removeNanoService(@NotNull Class<? extends IGeneratedRecord> aClass) throws CException {
        CUtilCheck.checkNotNull(aClass, "Missing Class", new Object[0]);
        try {
            Field f = aClass.getDeclaredField("ID");
            IId id = (IId)f.get(null);
            this.removeNanoService(id);
        }
        catch (Exception aE) {
            LOG.error(aE, "Couldn't get namespace for NanoService {}.", aClass.getName());
            throw new CException(29).append(aE.getMessage());
        }
    }

    private CNanoServiceEntry ensureSid(IId aSID) {
        CNanoServiceEntry se = this.getServiceEntry(aSID);
        if (se == null) {
            try {
                this.addNanoService(aSID, "");
            }
            catch (CException e) {
                e.printStackTrace();
            }
            se = this.getServiceEntry(aSID);
        }
        return se;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean existNanoService(@NotNull IId aSID) {
        HashMap<IId, CNanoServiceEntry> hashMap = this.mServices;
        synchronized (hashMap) {
            return this.mServices.containsKey(aSID);
        }
    }

    @NotNull
    IListenerRegistry getListenerRegistry() {
        return this.mListenerRegistry;
    }

    @NotNull
    IMessageHookRegistry getMessageHookRegistry() {
        return this.mMessageHookRegistry;
    }

    @NotNull
    IId getNID() {
        return this.mNID;
    }

    @Override
    @NotNull
    public String getName(@NotNull IId aSID) {
        CNanoServiceEntry se = this.getServiceEntry(aSID);
        if (se != null) {
            return se.getName();
        }
        return "";
    }

    @Override
    @NotNull
    public INanoServiceMonitor getNanoServiceMonitor() {
        return this.mMonitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getObserverCount() {
        int count = 0;
        HashMap<IId, CNanoServiceEntry> hashMap = this.mServices;
        synchronized (hashMap) {
            for (CNanoServiceEntry se : this.mServices.values()) {
                count += se.getObserverCount();
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getObserverCount(@NotNull IId aSID) {
        HashMap<IId, CNanoServiceEntry> hashMap = this.mServices;
        synchronized (hashMap) {
            CNanoServiceEntry se = this.getServiceEntry(aSID);
            if (se != null) {
                return se.getObserverCount();
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CNanoServiceEntry getServiceEntry(IId aSID) {
        HashMap<IId, CNanoServiceEntry> hashMap = this.mServices;
        synchronized (hashMap) {
            return this.mServices.get(aSID);
        }
    }

    private CNanoServiceEntry getServiceEntryEx(IId aSID) throws CException {
        CNanoServiceEntry entry = this.getServiceEntry(aSID);
        if (entry == null) {
            throw new CException(2302);
        }
        return entry;
    }

    @Override
    public void getServiceInfo(@NotNull IId aSID, @NotNull CRecord aRecord) throws CException {
        String action = "getServiceInfo";
        this.checkSID(aSID, "getServiceInfo");
        CNanoServiceEntry se = this.ensureSid(aSID);
        se.getServiceInfo(aRecord);
    }

    private String getServiceString(CNanoServiceEntry aServiceEntry) {
        String name = this.mNameDb.getRecordIdDatabase().getNameOrNull(aServiceEntry.getID());
        if (name == null) {
            name = aServiceEntry.getName();
        }
        if (CUtilString.isEmpty(name)) {
            name = aServiceEntry.getID().toString();
        }
        return name;
    }

    @Override
    public void notifyRegistered() {
        CStringProperties sp = new CStringProperties();
        sp.put("nid", this.mNID.toString());
        CServiceRegistry.getInstance().registerService(INanoServiceRegistry.class, sp, (Object)this);
    }

    @Override
    public void recallTrigger(@NotNull IId aSID) throws CException {
        String action = "recallTrigger";
        this.checkSID(aSID, "recallTrigger");
        CNanoServiceEntry se = this.getServiceEntryEx(aSID);
        se.recallTrigger();
    }

    @Override
    public void recallTrigger(@NotNull IId aSID, @Nullable CTargetAddress aAddress) throws CException {
        String action = "recallTrigger";
        this.checkSID(aSID, "recallTrigger");
        CNanoServiceEntry se = this.getServiceEntryEx(aSID);
        if (aAddress == null) {
            se.recallTrigger();
        } else {
            se.recallTrigger(aAddress);
        }
    }

    @Override
    public void addNanoService(Class<? extends IGeneratedRecord> aClass) throws CException {
        CUtilCheck.checkNotNull(aClass, "Missing Class", new Object[0]);
        try {
            Field f = aClass.getDeclaredField("ID");
            IId id = (IId)f.get(null);
            f = aClass.getDeclaredField("NAME");
            String name = (String)f.get(null);
            this.addNanoService(id, name);
        }
        catch (Exception aE) {
            LOG.error(aE, "Couldn't get namespace for NanoService {}.", aClass.getName());
            throw new CException(29).append(aE.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addNanoService(@NotNull IId aSID, @NotNull String aName) throws CException {
        String action = "registerService";
        this.checkSID(aSID, "registerService");
        CNanoServiceEntry entry = this.getServiceEntry(aSID);
        if (entry != null) {
            String name = entry.getName();
            if (name.isEmpty() && CUtilString.isValid(aName)) {
                entry.setName(aName);
                this.mNameDb.getRecordIdDatabase().putName(aSID, aName);
            }
        } else {
            entry = new CNanoServiceEntry(this, aSID, aName);
            HashMap<IId, CNanoServiceEntry> hashMap = this.mServices;
            synchronized (hashMap) {
                this.mServices.put(aSID, entry);
            }
            if (CUtilString.isValid(aName)) {
                this.mNameDb.getRecordIdDatabase().putName(aSID, aName);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Register NanoService <{}> in Namespace <{}>", this.getServiceString(entry), this.mNID);
            }
            this.mMonitor.triggerServiceRegistered(entry.getID(), entry.getName());
        }
    }

    @Override
    public void addNanoServiceAndObserver(@NotNull Class<? extends IGeneratedRecord> aClass, @NotNull CTargetAddress aAddress, boolean aSendLast) throws CException {
        this.addObserver(aClass, aAddress, aSendLast);
    }

    @Override
    public void addNanoServiceAndObserver(@NotNull IId aSID, @NotNull String aName, @NotNull CTargetAddress aAddress) throws CException {
        this.addNanoService(aSID, aName);
        this.addObserver(aSID, aAddress);
    }

    @Override
    public void removeAllObserver(@NotNull IId aSID) throws CException {
        String action = "removeAllObserver";
        this.checkSID(aSID, "removeAllObserver");
        CNanoServiceEntry se = this.getServiceEntryEx(aSID);
        se.removeAllObserver();
    }

    @Override
    public void removeObserver(@NotNull Class<? extends IGeneratedRecord> aClass, @NotNull CTargetAddress aAddress) throws CException {
        CUtilCheck.checkNotNull(aClass, "Missing Class", new Object[0]);
        try {
            Field f = aClass.getDeclaredField("ID");
            IId id = (IId)f.get(null);
            this.removeObserver(id, aAddress);
        }
        catch (Exception aE) {
            LOG.error(aE, "Couldn't get namespace for NanoService {}.", aClass.getName());
            throw new CException(29).append(aE.getMessage());
        }
    }

    @Override
    public void removeObserver(@NotNull IId aSID, @NotNull CTargetAddress aObserver) throws CException {
        String action = "removeObserver";
        this.checkSID(aSID, "removeObserver");
        CNanoServiceEntry se = this.getServiceEntry(aSID);
        if (se != null) {
            se.removeObserver(aObserver);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeObservers(@NotNull CTargetAddress aObserver) {
        HashMap<IId, CNanoServiceEntry> hashMap = this.mServices;
        synchronized (hashMap) {
            for (CNanoServiceEntry element : this.mServices.values()) {
                if (!element.removeObserver(aObserver)) continue;
                this.mMonitor.triggerObserverRemoved(element.getID(), element.getName(), aObserver);
            }
        }
    }

    void send(CMessage aMessage) throws CException {
        this.mMessageSender.sendNotification(aMessage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        HashMap<IId, CNanoServiceEntry> hashMap = this.mServices;
        synchronized (hashMap) {
            return this.mServices.size();
        }
    }

    public String toString() {
        return "ServiceRegistry[NanoServices=" + this.mServices.size() + "][observer=" + this.getObserverCount() + "]";
    }

    @Override
    public boolean triggerObserver(@NotNull IId aSID, @NotNull CMessage aTemplate) throws CException {
        String action = "triggerObserver";
        this.checkSID(aSID, "triggerObserver");
        CNanoServiceEntry se = this.ensureSid(aSID);
        return se.triggerObserver(aTemplate);
    }
}

