/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.shutdown;

import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.cli.records.CRecordCliAddHandler;
import de.sillysky.nyssr.cli.records.CRecordCliHandle;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.id.common.CWellKnownNID;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.impl.shutdown.IDependencies;
import de.sillysky.nyssr.impl.shutdown.IShutDownHandler;
import de.sillysky.nyssr.impl.shutdown.records.CRecordNotifyShutdown;
import de.sillysky.nyssr.impl.shutdown.records.CRecordShutdown;
import de.sillysky.nyssr.impl.shutdown.records.CRecordShutdownAddListener;
import de.sillysky.nyssr.impl.shutdown.records.CRecordShutdownRemoveListener;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.namespace.INamespace;
import de.sillysky.nyssr.nanoservice.INanoServiceRegistry;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.result.CResult;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.target.CTarget;
import de.sillysky.nyssr.target.registry.records.CRecordStartTarget;
import de.sillysky.nyssr.util.CUtilInteger;
import java.util.ArrayDeque;
import java.util.Deque;
import org.jetbrains.annotations.NotNull;

class CShutDownTarget
extends CTarget
implements IService,
IShutDownHandler {
    private static final ILogger LOG = CLoggerFactory.getLogger(CShutDownTarget.class);
    private static final String QUIT = "quit";
    private static final String HELP_QUIT = "ShutDown the node";
    private static final String EXIT = "exit";
    private static final IId MICRO_SERVICE_SESSION = CIdFactory.fromObject("ccf168c1-f18b-4229-85f9-24461a19ee6a");
    private final IDependencies mDependencies;
    private final Deque<CTargetAddress> mListeners = new ArrayDeque<CTargetAddress>();
    private boolean mRunning = false;
    private int mNumber = 0;
    private int mExitCode;

    public CShutDownTarget(@NotNull IDependencies aDependencies) {
        this.mDependencies = aDependencies;
    }

    @Override
    public void activate(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        this.addMessageHandler(CRecordStartTarget.ID, this::asyncStartTarget);
        this.addMessageHandler(CRecordShutdownAddListener.ID, this::asyncAddListener);
        this.addMessageHandler(CRecordShutdownRemoveListener.ID, this::asyncRemoveListener);
        this.addMessageHandler(CRecordShutdown.ID, this::asyncShutDown);
        this.addMessageHandler(CRecordNotifyShutdown.ID, this::asyncAnswerNotifyShutDown);
        this.addMessageHandler(CRecordCliHandle.ID, this::asyncCliHandle);
        INamespace ns = this.mDependencies.getNamespaceRegistry().getNamespace(CWellKnownNID.SYSTEM);
        assert (ns != null);
        ns.getTargetRegistry().registerTarget(this);
        aServiceRegistry.registerService(IShutDownHandler.class, this);
    }

    @Override
    public void deactivate(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        aServiceRegistry.deregisterService(this);
        this.deregisterTarget();
    }

    private boolean asyncStartTarget(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        INamespace ns = this.mDependencies.getNamespaceRegistry().getNamespace(CWellKnownNID.SYSTEM);
        assert (ns != null);
        INanoServiceRegistry sr = ns.getNanoServiceRegistry();
        CTargetAddress address = this.getAddress();
        sr.addNanoServiceAndObserver(CRecordShutdownAddListener.class, address, false);
        sr.addNanoServiceAndObserver(CRecordShutdownRemoveListener.class, address, false);
        sr.addNanoServiceAndObserver(CRecordShutdown.class, address, false);
        this.registerCliQuit();
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncAddListener(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        CTargetAddress sender = aEnvelope.getSender();
        if (this.mListeners.contains(sender)) {
            aEnvelope.setResult(16, "Already registered");
        } else {
            this.mListeners.offerLast(sender);
            aEnvelope.setResultSuccess();
        }
        return true;
    }

    private boolean asyncRemoveListener(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        this.mListeners.remove(aEnvelope.getSender());
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncShutDown(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        if (!this.mRunning) {
            this.mRunning = true;
            this.mExitCode = CRecordShutdown.getCode(aRecord, 0);
            this.shutDown();
        }
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncAnswerNotifyShutDown(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            CResult result = aEnvelope.getResult();
            if (LOG.isInfoEnabled()) {
                StringBuilder sb = new StringBuilder(1000);
                sb.append("ShutDown:\n");
                sb.append(String.format("%03d", this.mNumber));
                sb.append(String.format("%6d", result.getCode()));
                sb.append(result.getText());
                sb.append("\n");
                LOG.info(sb.toString());
            }
            this.shutDown();
            return true;
        }
        return false;
    }

    private boolean asyncCliHandle(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        String command = CRecordCliHandle.getCommand(aRecord, "");
        if (QUIT.equals(command) || EXIT.equals(command)) {
            String[] args = CRecordCliHandle.getArguments(aRecord, null);
            if (args != null && args.length >= 1 && args[0] != null) {
                this.mExitCode = CUtilInteger.fromObject(args[0], 0);
            }
            this.shutDown();
        }
        aEnvelope.setResultSuccess();
        return true;
    }

    private void shutDown() throws CException {
        if (this.mListeners.isEmpty()) {
            LOG.info("Exit with code {}", this.mExitCode);
            System.exit(this.mExitCode);
        } else {
            ++this.mNumber;
            CTargetAddress address = this.mListeners.removeFirst();
            CEnvelope env = CEnvelope.forSingleTarget(address);
            CRecord record = CRecordNotifyShutdown.create();
            this.sendRequest(env, record);
        }
    }

    private void registerCliQuit() throws CException {
        CEnvelope env = CEnvelope.forLocalNanoService(CWellKnownNID.SYSTEM);
        CRecord record = CRecordCliAddHandler.create();
        CRecordCliAddHandler.setCommand(record, new String[]{QUIT, EXIT});
        CRecordCliAddHandler.setHelp(record, new String[]{HELP_QUIT, HELP_QUIT});
        this.sendNotification(env, record);
    }
}

