/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.namespace.monitor.records;

import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.record.IGeneratedRecord;
import de.sillysky.nyssr.slot.CCommonSlotType;
import de.sillysky.nyssr.slot.CSlotFactoryHelper;
import de.sillysky.nyssr.slot.ISlot;
import org.jetbrains.annotations.NotNull;

public final class CRecordNamespaceMonitorAddFilter
implements IGeneratedRecord {
    public static final IId ID = CIdFactory.fromObject("ece310c9-0d58-4684-9ce5-b65024e65a61");
    public static final String NAME = "NamespaceMonitorAddFilter";
    public static final String DESCRIPTION = "Add an observer filter to the namespace monitor.";
    public static final String SLOT_FILTER = "1";
    public static final String SLOT_FILTER_LIST = "2";
    public static final String SLOT_OBSERVER = "3";
    public static final String[] NAMESPACES = new String[]{"SYSTEM"};
    public static final boolean IS_NANO_SERVICE = true;

    @NotNull
    public static CRecord create() {
        return new CRecord(ID);
    }

    public static IId getFilter(@NotNull CRecord aRecord, IId aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_FILTER);
        if (slot == null) {
            return aDefault;
        }
        return (IId)slot.getValue();
    }

    public static IId[] getFilterList(@NotNull CRecord aRecord, IId[] aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_FILTER_LIST);
        if (slot == null) {
            return aDefault;
        }
        return (IId[])slot.getValue();
    }

    public static CTargetAddress getObserver(@NotNull CRecord aRecord, CTargetAddress aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_OBSERVER);
        if (slot == null) {
            return aDefault;
        }
        return (CTargetAddress)slot.getValue();
    }

    public static void setFilter(@NotNull CRecord aRecord, IId aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject(CCommonSlotType.ID, aValue);
        aRecord.addSlot(SLOT_FILTER, slot);
    }

    public static void setFilterList(@NotNull CRecord aRecord, IId[] aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject(CCommonSlotType.ID_ARRAY, aValue);
        aRecord.addSlot(SLOT_FILTER_LIST, slot);
    }

    public static void setObserver(@NotNull CRecord aRecord, CTargetAddress aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject(CCommonSlotType.TARGET_ADDRESS, aValue);
        aRecord.addSlot(SLOT_OBSERVER, slot);
    }
}

