/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.record;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.impl.service.CServiceRegistry;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.record.CRecordPrinter;
import de.sillysky.nyssr.slot.CCommonSlotType;
import de.sillysky.nyssr.slot.CSlotType;
import de.sillysky.nyssr.slot.ISlot;
import de.sillysky.nyssr.slot.ISlotFactory;
import de.sillysky.nyssr.util.CPositiveInteger;
import de.sillysky.nyssr.util.CUtilString;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CRecord {
    private static final int HASH_TABLE_SIZE = 10;
    private static final ILogger LOG_FROM_STREAM = CLoggerFactory.getLogger("record.from.stream");
    private final HashMap<String, ISlot> mSlots = new HashMap(10);
    private final byte mVersion = 0;
    private IId mId;

    public CRecord(@NotNull CRecord aTemplate) {
        this.mId = aTemplate.mId;
        for (Map.Entry<String, ISlot> entry : aTemplate.getSlots().entrySet()) {
            String key = entry.getKey();
            ISlot slot = entry.getValue();
            this.addSlot(key, slot.copy());
        }
    }

    public CRecord(@NotNull IId aId) {
        this.mId = aId;
    }

    @NotNull
    public static CRecord fromStream(@NotNull DataInput aStream) throws IOException {
        ISlotFactory sf = CServiceRegistry.getInstance().getService(ISlotFactory.class);
        if (sf == null) {
            throw new IOException("No SlotFactory");
        }
        IId id = CIdFactory.fromStream(aStream, true);
        if (id == null) {
            LOG_FROM_STREAM.error("Record ID is null");
            return new CRecord(CIdFactory.getInvalid());
        }
        CRecord record = new CRecord(id);
        int size = CPositiveInteger.fromStream(aStream);
        for (int i = 0; i < size; ++i) {
            String key = CUtilString.fromStream(aStream);
            ISlot slot = sf.fromStream(aStream);
            if (slot == null) continue;
            record.addSlot(key, slot);
        }
        LOG_FROM_STREAM.debug("Record from Stream created: {}", record);
        return record;
    }

    @NotNull
    public ISlot addSlot(@NotNull String aKey, @NotNull ISlot aSlot) {
        this.mSlots.put(aKey, aSlot);
        return aSlot;
    }

    public void clearSlots() {
        this.mSlots.clear();
    }

    public boolean exist(@NotNull String aKey) {
        ISlot slot = this.mSlots.get(aKey);
        return slot == null;
    }

    @NotNull
    public IId getId() {
        return this.mId;
    }

    public void setId(@NotNull IId aId) {
        this.mId = aId;
    }

    @Nullable
    public ISlot getSlot(@NotNull String aKey, @NotNull CSlotType aType) throws CException {
        CSlotType found;
        ISlot slot = this.mSlots.get(aKey);
        if (slot != null && (found = slot.getType()) != aType) {
            throw new CException(2006).append("The slot type is wrong").append(" expected type = ").append(aType).append(" found type = ").append(found);
        }
        return slot;
    }

    @Nullable
    public ISlot getSlot(@NotNull String aKey) {
        return this.mSlots.get(aKey);
    }

    @NotNull
    public CSlotType getSlotType(@NotNull String aKey) {
        ISlot slot = this.mSlots.get(aKey);
        if (slot != null) {
            return slot.getType();
        }
        return CCommonSlotType.EMPTY;
    }

    @NotNull
    public Map<String, ISlot> getSlots() {
        return this.mSlots;
    }

    @Nullable
    public Object getValue(@NotNull String aKey) {
        ISlot slot = this.getSlot(aKey);
        if (slot != null) {
            return slot.getValue();
        }
        return null;
    }

    @Nullable
    public Object getValue(@NotNull String aKey, @NotNull CSlotType aType) throws CException {
        return this.getValue(aKey, aType, null);
    }

    @Nullable
    public Object getValue(@NotNull String aKey, @NotNull CSlotType aType, @Nullable Object aDefaultValue) throws CException {
        ISlot slot = this.getSlot(aKey, aType);
        if (slot != null) {
            return slot.getValue();
        }
        return aDefaultValue;
    }

    @Nullable
    public Object getValue(@NotNull String aKey, @Nullable Object aDefaultValue) {
        ISlot slot = this.getSlot(aKey);
        if (slot != null) {
            return slot.getValue();
        }
        return aDefaultValue;
    }

    public byte getVersion() {
        return 0;
    }

    @Nullable
    public ISlot removeSlot(@NotNull String aKey) {
        return this.mSlots.remove(aKey);
    }

    public void setValue(@NotNull String aKey, @NotNull CSlotType aType, @Nullable Object aValue) throws CException {
        ISlot slot = this.getSlot(aKey, aType);
        if (slot != null && slot.isContentEqualTo(aValue)) {
            return;
        }
        ISlotFactory sf = CServiceRegistry.getInstance().getService(ISlotFactory.class);
        if (sf != null) {
            ISlot newSlot = sf.fromObject(aType, aValue);
            this.addSlot(aKey, newSlot);
        }
    }

    public void setValueSafe(@NotNull String aKey, @NotNull CSlotType aType, @Nullable Object aValue) {
        try {
            this.setValue(aKey, aType, aValue);
        }
        catch (CException cException) {
            // empty catch block
        }
    }

    public int size() {
        return this.mSlots.size();
    }

    public void takeSlots(@NotNull CRecord aRecord) {
        for (Map.Entry<String, ISlot> entry : aRecord.getSlots().entrySet()) {
            this.addSlot(entry.getKey(), entry.getValue());
        }
    }

    public void toStream(@NotNull DataOutput aStream) throws IOException {
        ISlotFactory sf = CServiceRegistry.getInstance().getService(ISlotFactory.class);
        if (sf == null) {
            throw new IOException("no SlotFactory");
        }
        CIdFactory.toStream(aStream, this.mId);
        CPositiveInteger.toStream(aStream, this.mSlots.size());
        for (Map.Entry<String, ISlot> entry : this.mSlots.entrySet()) {
            String key = entry.getKey();
            ISlot value = entry.getValue();
            CUtilString.toStream(aStream, key);
            sf.toStream(aStream, value);
        }
    }

    public String toString() {
        return new CRecordPrinter(this).print();
    }

    public String toShortString() {
        return new CRecordPrinter(this).printShort();
    }

    @Contract(pure=true)
    @NotNull
    public Collection<String> getKeys() {
        return this.mSlots.keySet();
    }

    public boolean equals(Object aO) {
        if (this == aO) {
            return true;
        }
        if (aO == null || this.getClass() != aO.getClass()) {
            return false;
        }
        CRecord cRecord = (CRecord)aO;
        return this.mSlots.equals(cRecord.mSlots) && this.mId.equals(cRecord.mId);
    }

    public int hashCode() {
        return Objects.hash(this.mSlots, (byte)0, this.mId);
    }
}

