/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.util;

import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.util.CUtilString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CUtilByte {
    private static final ILogger LOG = CLoggerFactory.getLogger(CUtilByte.class);
    private static final char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final int LOW_NIBBLE = 15;
    private static final int HIGH_NIBBLE = 240;
    private static final int BITS_NIBBLE = 4;
    private static final int BITS_WORD = 16;

    private CUtilByte() {
    }

    public static byte fromObject(@Nullable Object aValue, byte aDefault) {
        byte result = aDefault;
        if (aValue != null) {
            if (aValue instanceof Float) {
                result = (byte)((Float)aValue).floatValue();
            } else if (aValue instanceof Double) {
                result = (byte)((Double)aValue).doubleValue();
            } else if (aValue instanceof Short) {
                result = (byte)((Short)aValue).shortValue();
            } else if (aValue instanceof Integer) {
                result = (byte)((Integer)aValue).intValue();
            } else if (aValue instanceof Long) {
                result = (byte)((Long)aValue).longValue();
            } else if (aValue instanceof Byte) {
                result = (Byte)aValue;
            } else if (aValue instanceof String) {
                String value = (String)aValue;
                if (!value.isEmpty()) {
                    try {
                        result = (byte)Integer.parseInt(value, 16);
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            } else {
                LOG.error("Can't convert object {} to byte. Take default value '{}'", aValue, aDefault);
            }
        }
        return result;
    }

    @NotNull
    public static String toString(byte aValue) {
        StringBuilder sb = new StringBuilder(4);
        CUtilByte.append(sb, aValue);
        return sb.toString();
    }

    public static String toString(byte aValue, int aMaxLen) {
        StringBuilder sb = new StringBuilder(2);
        CUtilByte.append(sb, aValue);
        return CUtilString.getShortenString(sb, aMaxLen);
    }

    public static void append(@NotNull StringBuilder aSb, byte aValue) {
        byte ch = (byte)(aValue & 0xF0);
        ch = (byte)(ch >> 4);
        ch = (byte)(ch & 0xF);
        aSb.append(HEX_CHARS[ch]);
        ch = (byte)(aValue & 0xF);
        aSb.append(HEX_CHARS[ch]);
    }
}

