/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.util;

import de.sillysky.nyssr.util.CPositiveInteger;
import de.sillysky.nyssr.util.CUtilRandom;
import de.sillysky.nyssr.util.CUtilStringArray;
import de.sillysky.nyssr.util.CUtilUuid;
import de.sillysky.nyssr.util.array.CUtilArray;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CUtilUuidArray {
    public static final UUID[] EMPTY = new UUID[0];
    private static final char ARRAY_DELIMITER = ',';

    private CUtilUuidArray() {
    }

    @Nullable
    public static UUID[] copy(@Nullable UUID[] aValue) {
        if (aValue == null) {
            return null;
        }
        return Arrays.copyOf(aValue, aValue.length);
    }

    public static UUID[] fromList(@Nullable List<?> aList) {
        if (aList == null || aList.isEmpty()) {
            return EMPTY;
        }
        ArrayList<UUID> list = new ArrayList<UUID>();
        for (Object element : aList) {
            if (element == null) continue;
            if (element instanceof UUID) {
                UUID e = (UUID)element;
                list.add(e);
                continue;
            }
            if (element instanceof UUID[]) {
                UUID[] ee = (UUID[])element;
                Collections.addAll(list, ee);
                continue;
            }
            if (!(element instanceof String)) continue;
            String s = (String)element;
            UUID[] ee = CUtilUuidArray.fromString(s);
            Collections.addAll(list, ee);
        }
        UUID[] arr = new UUID[list.size()];
        int pos = 0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            UUID element;
            arr[pos] = element = (UUID)iterator.next();
            ++pos;
        }
        return arr;
    }

    public static UUID @Nullable [] fromStream(@NotNull DataInput aStream) throws IOException {
        int len = CPositiveInteger.fromStream(aStream);
        if (len == 0) {
            return null;
        }
        UUID[] array = new UUID[len - 1];
        for (int i = 0; i < len - 1; ++i) {
            array[i] = CUtilUuid.fromStream(aStream);
        }
        return array;
    }

    public static UUID[] fromString(String aValue) {
        return CUtilUuidArray.fromString(aValue, ',');
    }

    public static UUID[] fromString(String aValue, char aDelimiter) {
        if (aValue == null || aValue.isEmpty()) {
            return EMPTY;
        }
        String[] strArray = CUtilStringArray.fromString(aValue, aDelimiter);
        if (strArray.length == 0) {
            return EMPTY;
        }
        UUID[] array = new UUID[strArray.length];
        for (int i = 0; i < strArray.length; ++i) {
            array[i] = CUtilUuid.fromString(strArray[i]);
        }
        return array;
    }

    public static UUID @NotNull [] random(int aLength, boolean aWithNullValues) {
        UUID[] array = new UUID[aLength];
        for (int i = 0; i < aLength; ++i) {
            boolean b = CUtilRandom.getRandom().nextBoolean();
            array[i] = b || !aWithNullValues ? CUtilUuid.random() : null;
        }
        return array;
    }

    public static boolean isEqual(UUID[] aValue1, UUID[] aValue2) {
        return Arrays.equals(aValue1, aValue2);
    }

    public static void toStream(@NotNull DataOutput aStream, UUID @Nullable [] aValue) throws IOException {
        if (aValue == null) {
            CPositiveInteger.toStream(aStream, 0);
        } else {
            CPositiveInteger.toStream(aStream, aValue.length + 1);
            for (UUID element : aValue) {
                CUtilUuid.toStream(aStream, element);
            }
        }
    }

    @NotNull
    public static String toString(UUID @Nullable [] aValue, char aDelimiter, int aMaxLen) {
        if (aValue == null) {
            return "null";
        }
        return CUtilArray.toString(0, aDelimiter, aMaxLen, index -> index >= aValue.length ? "\uf00bE" : CUtilUuid.toString(aValue[index]));
    }
}

