/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.util.cmdline;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class CSimpleArgParser {
    private final Map<String, String> options = new HashMap<String, String>();
    private final Set<String> flags = new HashSet<String>();
    private final List<String> positional = new ArrayList<String>();

    public CSimpleArgParser(String @NotNull [] args) {
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.startsWith("--")) {
                if (arg.contains("=")) {
                    String[] parts = arg.split("=", 2);
                    this.options.put(parts[0].substring(2), parts[1]);
                    continue;
                }
                if (i + 1 < args.length && !args[i + 1].startsWith("-")) {
                    this.options.put(arg.substring(2), args[++i]);
                    continue;
                }
                this.flags.add(arg.substring(2));
                continue;
            }
            if (arg.startsWith("-") && arg.length() > 1) {
                String shortOpts = arg.substring(1);
                if (shortOpts.length() > 1) {
                    for (char opt : shortOpts.toCharArray()) {
                        this.flags.add(String.valueOf(opt));
                    }
                    continue;
                }
                if (i + 1 < args.length && !args[i + 1].startsWith("-")) {
                    this.options.put(shortOpts, args[++i]);
                    continue;
                }
                this.flags.add(shortOpts);
                continue;
            }
            this.positional.add(arg);
        }
    }

    public String getOption(String key) {
        return this.options.get(key);
    }

    public boolean hasFlag(String key) {
        return this.flags.contains(key);
    }

    public List<String> getPositionalArguments() {
        return this.positional;
    }
}

