/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.util.crypt;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;

public final class CUtilCrypt {
    private CUtilCrypt() {
    }

    public static void decryptFile(File aFileIn, File aFileOut, String aPassword, byte[] aSalt, byte[] aIterationVector) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException {
        SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA256");
        PBEKeySpec spec = new PBEKeySpec(aPassword.toCharArray(), aSalt, 65536, 256);
        SecretKey tmp = factory.generateSecret(spec);
        SecretKeySpec key = new SecretKeySpec(tmp.getEncoded(), "AES");
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        cipher.init(2, (Key)key, new IvParameterSpec(aIterationVector));
        try (FileInputStream fis = new FileInputStream(aFileIn);
             CipherInputStream cis = new CipherInputStream(fis, cipher);
             FileOutputStream fos = new FileOutputStream(aFileOut);){
            int count;
            byte[] buffer = new byte[8192];
            while ((count = cis.read(buffer)) > 0) {
                fos.write(buffer, 0, count);
            }
        }
    }

    public static byte[] encryptFile(File aFileIn, File aFileOut, byte[] aSalt, String aPassword) throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidKeyException, IOException, InvalidParameterSpecException {
        SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA256");
        PBEKeySpec spec = new PBEKeySpec(aPassword.toCharArray(), aSalt, 65536, 256);
        SecretKey tmp = factory.generateSecret(spec);
        SecretKeySpec key = new SecretKeySpec(tmp.getEncoded(), "AES");
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        AlgorithmParameters params = cipher.getParameters();
        byte[] iv = params.getParameterSpec(IvParameterSpec.class).getIV();
        cipher.init(1, key);
        try (FileInputStream fis = new FileInputStream(aFileIn);
             FileOutputStream fos = new FileOutputStream(aFileOut);
             CipherOutputStream out = new CipherOutputStream(fos, cipher);){
            int count;
            byte[] buffer = new byte[8192];
            while ((count = fis.read(buffer)) > 0) {
                out.write(buffer, 0, count);
            }
        }
        return iv;
    }
}

