/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.util.stringrecord;

public final class CStringRecord {
    private final String mKey;
    private final String mValue;
    private final String mValueEscaped;

    public CStringRecord(String aRecord) {
        int i = aRecord.indexOf(61);
        this.mKey = aRecord.substring(0, i);
        int max = aRecord.length();
        if (i < max - 1) {
            this.mValueEscaped = aRecord.substring(i + 1, max);
            this.mValue = this.mValueEscaped.replace("\\}", "}");
        } else {
            this.mValueEscaped = "";
            this.mValue = "";
        }
    }

    public CStringRecord(String aKey, String aValue) {
        this.mKey = aKey == null ? "" : aKey;
        this.mValue = aValue == null ? "" : aValue;
        this.mValueEscaped = this.mValue.replace("}", "\\}");
    }

    public boolean equals(Object aObj) {
        if (this == aObj) {
            return true;
        }
        if (aObj == null) {
            return false;
        }
        if (this.getClass() != aObj.getClass()) {
            return false;
        }
        CStringRecord other = (CStringRecord)aObj;
        if (this.mKey == null) {
            return other.mKey == null;
        }
        return this.mKey.equals(other.mKey);
    }

    public String getEscapedValue() {
        return this.mValueEscaped;
    }

    public String getKey() {
        return this.mKey;
    }

    public String getRecordString() {
        int len = 3 + this.mKey.length() + this.mValueEscaped.length();
        return '{' + this.mKey + '=' + this.mValueEscaped + '}';
    }

    public String getValue() {
        return this.mValue;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.mKey == null ? 0 : this.mKey.hashCode());
        return result;
    }

    public String toString() {
        int len = 3 + this.mKey.length() + this.mValue.length();
        return '{' + this.mKey + '=' + this.mValue + '}';
    }
}

