/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.remoteskin.server.widgets;

import de.sillysky.nyssr.id.widget.CWidgetId;
import de.sillysky.nyssr.id.widget.CWidgetSetId;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.remoteskin.server.context.IRemoteSkinServerContext;
import de.sillysky.nyssr.remoteskin.server.listeners.IListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CServerWidget {
    private static final ILogger LOG = CLoggerFactory.getLogger(CServerWidget.class);
    private final Set<IListener> mListeners = new HashSet<IListener>();
    private final CWidgetId mWidgetId;
    private IRemoteSkinServerContext mServerContext;

    public CServerWidget(@NotNull CWidgetId aWidgetId) {
        this.mWidgetId = aWidgetId;
    }

    public CServerWidget(@NotNull String aWidgetSetName, @NotNull String aWidgetSetInstance, @NotNull String aWidgetName) {
        this.mWidgetId = CWidgetId.create((String)aWidgetName, (String)aWidgetSetName, (String)aWidgetSetInstance);
    }

    public CServerWidget(@NotNull CWidgetSetId aWidgetSetId, @NotNull String aWidgetName) {
        this.mWidgetId = CWidgetId.create((String)aWidgetName, (CWidgetSetId)aWidgetSetId);
    }

    public CWidgetId getWidgetId() {
        return this.mWidgetId;
    }

    protected void addAttribute(@NotNull String aKey, @Nullable Object aValue) {
        if (this.mServerContext != null) {
            if (aValue != null) {
                this.mServerContext.getSender().addAttribute(this.mWidgetId, aKey, aValue);
            }
        } else {
            LOG.error("No ServerContext in ServerWidget {}", new Object[]{this.mWidgetId});
        }
    }

    public void setServerContext(@Nullable IRemoteSkinServerContext aServerContext) {
        this.mServerContext = aServerContext;
    }

    public void addListener(IListener aListener) {
        this.mListeners.add(aListener);
    }

    protected <T extends IListener> List<T> getListeners(Class<T> aClass) {
        ArrayList<IListener> list = new ArrayList<IListener>();
        for (IListener l : this.mListeners) {
            if (!aClass.isAssignableFrom(l.getClass())) continue;
            list.add(l);
        }
        return list;
    }

    public void applyNotification(@NotNull String aKey, @NotNull Object aValue) throws Exception {
        System.err.println("CServerWidget.applyNotification!");
    }
}

