/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.microservice.helper;

import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.microservice.collector.CMicroServiceInstance;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.jetbrains.annotations.NotNull;

class CLocalMicroServiceList {
    private final Set<CMicroServiceInstance> mMicroServices = new CopyOnWriteArraySet<CMicroServiceInstance>();

    CLocalMicroServiceList() {
    }

    boolean add(@NotNull CMicroServiceInstance aInstance) {
        return this.mMicroServices.add(aInstance);
    }

    void remove(@NotNull CMicroServiceInstance aInstance) {
        this.mMicroServices.remove(aInstance);
    }

    void remove(@NotNull IId aInstanceId) {
        this.mMicroServices.removeIf(service -> service.getInstanceId().equals((Object)aInstanceId));
    }

    @NotNull
    List<CMicroServiceInstance> getPending() {
        return new ArrayList<CMicroServiceInstance>(this.mMicroServices);
    }

    @NotNull
    List<CMicroServiceInstance> getFromOwner(@NotNull CTargetAddress aOwner) {
        ArrayList<CMicroServiceInstance> list = new ArrayList<CMicroServiceInstance>();
        for (CMicroServiceInstance inst : this.mMicroServices) {
            if (!inst.getTargetAddress().equals((Object)aOwner)) continue;
            list.add(inst);
        }
        return list;
    }

    public String toString() {
        return "[LocalMicroServiceList: size=" + this.mMicroServices.size() + "]";
    }
}

