/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.microservice.collector.target;

import de.sillysky.nyssr.address.CNodeAddress;
import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.cli.records.CRecordCliAddHandler;
import de.sillysky.nyssr.cli.records.CRecordCliHandle;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.exception.CUtilCheck;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.id.common.CWellKnownNID;
import de.sillysky.nyssr.impl.microservice.collector.target.IDependencies;
import de.sillysky.nyssr.impl.microservice.collector.target.IMicroServiceCollectorTarget;
import de.sillysky.nyssr.kernel.configuration.ETypeOfNode;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.microservice.registry.broadcast.records.CRecordBroadcastMicroServiceRegistryCreated;
import de.sillysky.nyssr.microservice.registry.broadcast.records.CRecordBroadcastMicroServiceRegistryDeleted;
import de.sillysky.nyssr.microservice.registry.helper.records.CRecordNotifyMicroServiceRegistryCreated;
import de.sillysky.nyssr.microservice.registry.helper.records.CRecordNotifyMicroServiceRegistryDeleted;
import de.sillysky.nyssr.microservice.registry.records.CRecordForwardToMicroServiceInstance;
import de.sillysky.nyssr.namespace.INamespace;
import de.sillysky.nyssr.nanoservice.INanoServiceRegistry;
import de.sillysky.nyssr.notification.records.CRecordNotifyRemoteNodeAdded;
import de.sillysky.nyssr.notification.records.CRecordNotifyRemoteNodeRemoved;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.target.CTarget;
import de.sillysky.nyssr.target.ITarget;
import de.sillysky.nyssr.target.registry.records.CRecordStartTarget;
import de.sillysky.nyssr.util.CUtilEnum;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

class CTargetMicroServiceRegistryCollector
extends CTarget
implements IService,
IMicroServiceCollectorTarget {
    private static final IId[] OBSERVED = new IId[]{CRecordBroadcastMicroServiceRegistryCreated.ID, CRecordBroadcastMicroServiceRegistryDeleted.ID, CRecordNotifyRemoteNodeAdded.ID, CRecordNotifyRemoteNodeRemoved.ID};
    private static final String COMMAND = "msc";
    private static final String COMMAND_HELP = "Show the status of the micro service collector";
    private INamespace mNamespace;
    private final IDependencies mDependencies;

    CTargetMicroServiceRegistryCollector(@NotNull IDependencies aDependencies) {
        this.mDependencies = aDependencies;
    }

    public void activate(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        this.addMessageHandler(CRecordStartTarget.ID, this::asyncStartTarget);
        this.addMessageHandler(CRecordBroadcastMicroServiceRegistryCreated.ID, this::asyncBroadcastMicroServiceRegistryCreated);
        this.addMessageHandler(CRecordBroadcastMicroServiceRegistryDeleted.ID, this::asyncBroadcastMicroServiceRegistryDeleted);
        this.addMessageHandler(CRecordNotifyRemoteNodeRemoved.ID, this::asyncNotifyRemoteNodeRemoved);
        this.addMessageHandler(CRecordNotifyRemoteNodeAdded.ID, this::asyncNotifyRemoteNodeAdded);
        this.addMessageHandler(CRecordForwardToMicroServiceInstance.ID, this::asyncForwardToMicroServiceInstance);
        this.addMessageHandler(CRecordCliHandle.ID, this::asyncCliHandle);
        this.mNamespace = this.mDependencies.getNamespaceFactory().getNamespace(CWellKnownNID.SYSTEM);
        assert (this.mNamespace != null);
        this.mNamespace.getTargetRegistry().registerTarget((ITarget)this);
    }

    private boolean asyncStartTarget(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        this.mDependencies.getPrivateMicroServiceRegistryCollector().setTarget(this);
        CTargetAddress address = this.getAddress();
        INanoServiceRegistry sr = this.mNamespace.getNanoServiceRegistry();
        sr.addObservers(OBSERVED, address, true);
        this.sendAddCli();
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncBroadcastMicroServiceRegistryCreated(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        CTargetAddress address = CRecordBroadcastMicroServiceRegistryCreated.getMicroServiceAddress((CRecord)aRecord, null);
        CUtilCheck.checkNotNull((Object)address, (String)"Address is null", (Object[])new Object[0]);
        this.mDependencies.getPrivateMicroServiceRegistryCollector().addRegistry(address);
        this.sendNotifyCreated(address);
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncBroadcastMicroServiceRegistryDeleted(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        CTargetAddress address = CRecordBroadcastMicroServiceRegistryDeleted.getMicroServiceAddress((CRecord)aRecord, null);
        CUtilCheck.checkNotNull((Object)address, (String)"Address is null", (Object[])new Object[0]);
        boolean removed = this.mDependencies.getPrivateMicroServiceRegistryCollector().removeRegistry(address);
        if (removed) {
            this.sendNotifyDeleted(address);
        }
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncForwardToMicroServiceInstance(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        return aEnvelope.isAnswer();
    }

    private boolean asyncNotifyRemoteNodeAdded(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        String type;
        ETypeOfNode typeOfNode;
        if (aEnvelope.isAnswer()) {
            return false;
        }
        if (this.mDependencies.getClientHandlingService().isAlternateRoutingEnabled() && ETypeOfNode.CLIENT.equals((Object)(typeOfNode = (ETypeOfNode)CUtilEnum.fromString(ETypeOfNode.class, (String)(type = CRecordNotifyRemoteNodeAdded.getType((CRecord)aRecord, null)), (Object)ETypeOfNode.UNKNOWN)))) {
            CNodeAddress node = CRecordNotifyRemoteNodeAdded.getRemoteNode((CRecord)aRecord, null);
            CUtilCheck.checkNotNull((Object)node, (String)"Node Address missing", (Object[])new Object[0]);
            if (this.mDependencies.getRouter().isNeighbor(node)) {
                this.sendRegistryCreated(node);
            }
        }
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncNotifyRemoteNodeRemoved(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        CNodeAddress node = CRecordNotifyRemoteNodeRemoved.getRemoteNode((CRecord)aRecord, null);
        CUtilCheck.checkNotNull((Object)node, (String)"Node Address missing", (Object[])new Object[0]);
        this.mDependencies.getPrivateMicroServiceRegistryCollector().notifyNodeRemoved(node);
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncCliHandle(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        String command = CRecordCliHandle.getCommand((CRecord)aRecord, (String)"");
        if (COMMAND.equalsIgnoreCase(command)) {
            String s = this.mDependencies.getPrivateMicroServiceRegistryCollector().getDump();
            CRecordCliHandle.setOutput((CRecord)aRecord, (String)s);
        }
        aEnvelope.setResultSuccess();
        return true;
    }

    public void deactivate(@NotNull IServiceRegistry aServiceRegistry) {
        this.deregisterTarget();
    }

    private void sendNotifyCreated(CTargetAddress aAddress) throws CException {
        CEnvelope env = new CEnvelope();
        CRecord rec = CRecordNotifyMicroServiceRegistryCreated.create();
        CRecordNotifyMicroServiceRegistryCreated.setMicroServiceRegistryAddress((CRecord)rec, (CTargetAddress)aAddress);
        this.sendNotification(env, rec);
    }

    private void sendNotifyDeleted(CTargetAddress aAddress) throws CException {
        CEnvelope env = new CEnvelope();
        CRecord rec = CRecordNotifyMicroServiceRegistryDeleted.create();
        CRecordNotifyMicroServiceRegistryDeleted.setMicroServiceRegistryAddress((CRecord)rec, (CTargetAddress)aAddress);
        this.sendNotification(env, rec);
    }

    @Override
    public void sendToRegistry(@NotNull CTargetAddress aAddressOfMicroServiceRegistry, @NotNull CRecord aRecord) throws CException {
        CEnvelope env = CEnvelope.forSingleTarget((CTargetAddress)aAddressOfMicroServiceRegistry);
        this.sendRequest(env, aRecord);
    }

    @Override
    public void sendToRegistry(@NotNull CNodeAddress aNodeAddressOfOtherSegment, @NotNull CRecord aRecord) throws CException {
        CEnvelope env = CEnvelope.forRemoteNanoService((IId)CWellKnownNID.SYSTEM, (CNodeAddress)aNodeAddressOfOtherSegment);
        this.sendRequest(env, aRecord);
    }

    private void sendAddCli() throws CException {
        CEnvelope env = CEnvelope.forLocalNanoService((IId)CWellKnownNID.SYSTEM);
        CRecord record = CRecordCliAddHandler.create();
        CRecordCliAddHandler.setCommand((CRecord)record, (String[])new String[]{COMMAND});
        CRecordCliAddHandler.setHelp((CRecord)record, (String[])new String[]{COMMAND_HELP});
        this.sendNotification(env, record);
    }

    private void sendRegistryCreated(@NotNull CNodeAddress aNode) throws CException {
        Collection addresses = this.mDependencies.getMicroServiceRegistryCollector().getAddresses();
        for (CTargetAddress address : addresses) {
            CEnvelope env = CEnvelope.forRemoteNanoService((IId)CWellKnownNID.SYSTEM, (CNodeAddress)aNode);
            CRecord rec = CRecordBroadcastMicroServiceRegistryCreated.create();
            CRecordBroadcastMicroServiceRegistryCreated.setMicroServiceAddress((CRecord)rec, (CTargetAddress)address);
            this.sendNotification(env, rec);
        }
    }
}

