/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.microservice.registry.service;

import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.microservice.registry.service.CListenerEntry;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

class CListenerList {
    private final IId mMicroServiceId;
    private final Set<CListenerEntry> mEntries = new HashSet<CListenerEntry>();

    CListenerList(IId aMicroServiceId) {
        this.mMicroServiceId = aMicroServiceId;
    }

    void add(@NotNull CListenerEntry aEntry) {
        this.mEntries.add(aEntry);
    }

    void remove(@NotNull CTargetAddress aAddress) {
        this.mEntries.removeIf(entry -> entry.getAddress().equals((Object)aAddress));
    }

    void remove(@NotNull CListenerEntry aEntry) {
        this.mEntries.remove(aEntry);
    }

    Iterator<CListenerEntry> iterator() {
        return this.mEntries.iterator();
    }

    int size() {
        return this.mEntries.size();
    }

    IId getMicroServiceId() {
        return this.mMicroServiceId;
    }

    public String toString() {
        return this.size() + " Entries";
    }
}

