/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.microservice.registry.target2;

import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.microservice.registry.records.CRecordRequestMicroServiceUpdate;
import de.sillysky.nyssr.impl.microservice.registry.service.CMicroServiceEntry;
import de.sillysky.nyssr.impl.microservice.registry.service.CMicroServiceInstanceEntry;
import de.sillysky.nyssr.impl.microservice.registry.service.IMicroServiceRegistry;
import de.sillysky.nyssr.microservice.collector.CMicroServiceDescription;
import de.sillysky.nyssr.microservice.registry.records.CRecordMicroServiceInstance;
import de.sillysky.nyssr.record.CRecord;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

class CUpdate {
    private CUpdate() {
    }

    public static void fromRecord(@NotNull IMicroServiceRegistry aRegistry, @NotNull CRecord aRecord) throws CException {
        CRecord[] instArray;
        CRecord[] msArray;
        for (CRecord record : msArray = CRecordRequestMicroServiceUpdate.getMicroServices(aRecord, null)) {
            CMicroServiceDescription desc = CMicroServiceDescription.fromRecord((CRecord)record);
            aRegistry.addMicroService(desc);
        }
        for (CRecord record : instArray = CRecordRequestMicroServiceUpdate.getInstances(aRecord, null)) {
            IId id = CRecordMicroServiceInstance.getMicroServiceId((CRecord)record, null);
            CMicroServiceEntry microService = aRegistry.getMicroService(id);
            if (microService == null) continue;
            IId instanceId = CRecordMicroServiceInstance.getMicroServiceInstanceId((CRecord)record, null);
            CTargetAddress address = CRecordMicroServiceInstance.getMicroServiceAddress((CRecord)record, null);
            ZonedDateTime timeAdded = CRecordMicroServiceInstance.getTimeAdded((CRecord)record, null);
            microService.addInstance(instanceId, address, timeAdded);
        }
    }

    public static void toRecord(@NotNull IMicroServiceRegistry aRegistry, @NotNull CRecord aRecord) throws CException {
        Collection<CMicroServiceEntry> microServiceEntries = aRegistry.getMicroServiceEntries();
        ArrayList<CRecord> instanceRecordList = new ArrayList<CRecord>();
        int msSize = microServiceEntries.size();
        CRecord[] recordsServices = new CRecord[msSize];
        boolean i = false;
        for (CMicroServiceEntry e : microServiceEntries) {
            recordsServices[0] = e.getMicroService().valueToRecord();
            for (CMicroServiceInstanceEntry instanceEntry : e.getInstances()) {
                CRecord rec = instanceEntry.toRecord();
                instanceRecordList.add(rec);
            }
        }
        CRecord[] instanceRecordArray = instanceRecordList.toArray(new CRecord[0]);
        CRecordRequestMicroServiceUpdate.setMicroServices(aRecord, recordsServices);
        CRecordRequestMicroServiceUpdate.setInstances(aRecord, instanceRecordArray);
    }
}

