/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.tcp.client;

import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.EIdType;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.id.common.CWellKnownNID;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.impl.shutdown.records.CRecordNotifyShutdown;
import de.sillysky.nyssr.impl.shutdown.records.CRecordShutdownAddListener;
import de.sillysky.nyssr.impl.tcp.client.CTcpClient;
import de.sillysky.nyssr.impl.tcp.client.IDependencies;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.namespace.INamespace;
import de.sillysky.nyssr.network.connection.records.CRecordDataConnection;
import de.sillysky.nyssr.network.records.CRecordNetworkNotifyConnectionClosed;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.record.helper.CRecordHelper;
import de.sillysky.nyssr.target.CTarget;
import de.sillysky.nyssr.target.ITarget;
import de.sillysky.nyssr.target.registry.records.CRecordStartTarget;
import de.sillysky.nyssr.tcp.records.CRecordTcpCreateClientRetry;
import de.sillysky.nyssr.tcp.records.CRecordTcpNotifyClientDeleted;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;

final class CTargetForTcpClient
extends CTarget {
    private static final ILogger LOG = CLoggerFactory.getLogger(CTargetForTcpClient.class);
    private static final IId TIMER_RETRY = CIdFactory.fromObject((EIdType)EIdType.STRING, (Object)"TimerRetryConnect");
    private long mTimerHandle = 0L;
    private long mRetryTimeout = 0L;
    private CTcpClient mClient;
    private IDependencies mDependencies;

    CTargetForTcpClient() {
    }

    void activate(IDependencies aDependencies, CTcpClient aClient, long aRetryTimeout) throws CException {
        this.mDependencies = aDependencies;
        LOG.debug("Activate {} {}", new Object[]{((Object)((Object)this)).getClass().getSimpleName(), System.identityHashCode((Object)this)});
        this.mClient = aClient;
        this.mRetryTimeout = aRetryTimeout;
        this.addMessageHandler(CRecordStartTarget.ID, this::asyncStartTarget);
        this.addMessageHandler(CRecordNetworkNotifyConnectionClosed.ID, this::asyncNotifyConnectionClosed);
        this.addMessageHandler(TIMER_RETRY, this::asyncTimerRetry);
        this.addMessageHandler(CRecordNotifyShutdown.ID, this::asyncNotifyShutDown);
        INamespace ns = this.mDependencies.getNamespaceFactory().createAndRegisterNamespace(CWellKnownNID.TCP_FACTORY, "TCP_FACTORY");
        ns.getTargetRegistry().registerTarget((ITarget)this);
    }

    private boolean asyncStartTarget(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        CTargetAddress address = this.getAddress();
        this.mDependencies.getNameDb().getTargetAddressDatabase().putName(address, "TcpClient");
        CRecordHelper.addObserver(CRecordNetworkNotifyConnectionClosed.class, (ITarget)this, (boolean)false);
        this.sendAddShutDownListener();
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncNotifyConnectionClosed(CEnvelope aEnvelope, CRecord aRecord) {
        CRecord connection = CRecordNetworkNotifyConnectionClosed.getConnection((CRecord)aRecord, null);
        UUID id = CRecordDataConnection.getConnectionId((CRecord)connection, null);
        if (this.mClient != null && this.mClient.getConnectionID().equals(id)) {
            LOG.info("Notify connection closed received for connection {}", new Object[]{id});
            if (this.mRetryTimeout > 0L) {
                this.startTimer();
            }
        }
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncTimerRetry(CEnvelope aEnvelope, CRecord aRecord) {
        block2: {
            this.mTimerHandle = 0L;
            try {
                this.mClient.reconnect();
            }
            catch (Exception e) {
                if (this.mRetryTimeout <= 0L) break block2;
                this.startTimer();
            }
        }
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncNotifyShutDown(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        LOG.debug("Tcp Client: Got shutdown.");
        this.deregisterTarget();
        aEnvelope.setResultSuccess();
        return true;
    }

    void deactivate() {
        LOG.debug("Deactivate {} {}", new Object[]{((Object)((Object)this)).getClass().getSimpleName(), System.identityHashCode((Object)this)});
        this.deregisterTarget();
        this.mClient = null;
    }

    void setRetryTimer(long aTimeout) {
        this.mRetryTimeout = aTimeout;
        this.startTimer();
    }

    private void startTimer() {
        if (this.mTimerHandle == 0L && this.mRetryTimeout > 0L) {
            this.mTimerHandle = this.mDependencies.getTimerManager().createAndStartTimer(TIMER_RETRY, this.getAddress(), this.mRetryTimeout, false, null);
        }
    }

    void sendRetryMessage() {
        try {
            CEnvelope env = CEnvelope.forSingleTarget((CTargetAddress)this.mClient.getOwner());
            CRecord record = CRecordTcpCreateClientRetry.create();
            CRecordTcpCreateClientRetry.setId((CRecord)record, (UUID)this.mClient.getID());
            CRecordTcpCreateClientRetry.setTimeout((CRecord)record, (long)this.mClient.getRetryTimeout());
            CRecordTcpCreateClientRetry.setRetryCount((CRecord)record, (int)this.mClient.getRetryCounter());
            this.sendNotification(env, record);
        }
        catch (CException aE) {
            LOG.error((Throwable)aE, "Couldn't send Retry Hint Message to Owner.");
        }
    }

    void sendNotifyClientDeleted(@NotNull CTargetAddress aAddress) {
        try {
            CEnvelope env = CEnvelope.forSingleTarget((CTargetAddress)aAddress);
            CRecord record = CRecordTcpNotifyClientDeleted.create();
            CRecordTcpNotifyClientDeleted.setId((CRecord)record, (UUID)this.mClient.getID());
            CRecordTcpNotifyClientDeleted.setHost((CRecord)record, (String)this.mClient.getHost());
            CRecordTcpNotifyClientDeleted.setPort((CRecord)record, (int)this.mClient.getPort());
            this.sendNotification(env, record);
        }
        catch (CException aE) {
            LOG.error((Throwable)aE, "Couldn't send Notify Client Deleted Message to Owner.");
        }
    }

    private void sendAddShutDownListener() throws CException {
        CEnvelope env = CEnvelope.forLocalNanoService((IId)CWellKnownNID.SYSTEM);
        CRecord record = CRecordShutdownAddListener.create();
        this.sendNotification(env, record);
    }
}

