/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.tcp.server;

import de.sillysky.nyssr.impl.tcp.server.CTcpServerFactory;
import de.sillysky.nyssr.impl.tcp.server.IDependencies;
import de.sillysky.nyssr.namedb.INameDb;
import de.sillysky.nyssr.namespace.INamespace;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceDependencyList;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.service.IServiceStarter;
import de.sillysky.nyssr.tcp.ITcpConnectionFactory;
import org.jetbrains.annotations.NotNull;

public final class CPackageTcpServer
implements IServiceStarter,
IDependencies {
    private static final String FILTER = "nid=TCP";
    private IService mService;
    private INameDb mNameDb;
    private INamespace mNamespace;
    private ITcpConnectionFactory mTcpConnectionFactory;

    public void getDependencies(@NotNull IServiceDependencyList aDependencyList) {
        aDependencyList.add(INameDb.class);
        aDependencyList.add(INamespace.class, FILTER);
        aDependencyList.add(ITcpConnectionFactory.class);
    }

    public void start(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        if (this.mService == null) {
            this.mNameDb = (INameDb)aServiceRegistry.getServiceOrThrow(INameDb.class);
            this.mNamespace = (INamespace)aServiceRegistry.getServiceOrThrow(INamespace.class);
            this.mTcpConnectionFactory = (ITcpConnectionFactory)aServiceRegistry.getServiceOrThrow(ITcpConnectionFactory.class);
            this.mService = new CTcpServerFactory(this);
            this.mService.activate(aServiceRegistry);
        }
    }

    public void stop(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        if (this.mService != null) {
            this.mService.deactivate(aServiceRegistry);
        }
    }

    @Override
    @NotNull
    public INameDb getNameDb() {
        return this.mNameDb;
    }

    @Override
    @NotNull
    public INamespace getNamespace() {
        return this.mNamespace;
    }

    @Override
    @NotNull
    public ITcpConnectionFactory getTcpConnectionFactory() {
        return this.mTcpConnectionFactory;
    }
}

