/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.message.panel.records;

import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.id.widget.CWidgetId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.record.IGeneratedRecord;
import de.sillysky.nyssr.slot.CCommonSlotType;
import de.sillysky.nyssr.slot.CSlotFactoryHelper;
import de.sillysky.nyssr.slot.CSlotType;
import de.sillysky.nyssr.slot.ISlot;
import java.awt.Color;
import org.jetbrains.annotations.NotNull;

public final class CRecordOpenDialogMessagePanel
implements IGeneratedRecord {
    public static final IId ID = CIdFactory.fromObject((Object)"36889cf6-e037-44ab-8373-a4cc57a508a6");
    public static final String NAME = "OpenDialogMessagePanel";
    public static final String DESCRIPTION = "Embed a message panel into a widget set. Source: RemoteSkin server target (owner). Destination: Message Panel Main target. Is derived from CRecordOpenDialog";
    public static final String SLOT_BACKGROUND = "3";
    public static final String SLOT_CENTER_DLG_ABOVE = "2";
    public static final String SLOT_DIALOG_TARGET_ADDRESS = "100";
    public static final String SLOT_FOREGROUND = "4";
    public static final String SLOT_PANEL_TYPE = "1";
    public static final String[] NAMESPACES = new String[0];
    public static final boolean IS_NANO_SERVICE = false;

    @NotNull
    public static CRecord create() {
        return new CRecord(ID);
    }

    public static Color getBackground(@NotNull CRecord aRecord, Color aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_BACKGROUND);
        if (slot == null) {
            return aDefault;
        }
        return (Color)slot.getValue();
    }

    public static CWidgetId getCenterDlgAbove(@NotNull CRecord aRecord, CWidgetId aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_CENTER_DLG_ABOVE);
        if (slot == null) {
            return aDefault;
        }
        return (CWidgetId)slot.getValue();
    }

    public static CTargetAddress getDialogTargetAddress(@NotNull CRecord aRecord, CTargetAddress aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_DIALOG_TARGET_ADDRESS);
        if (slot == null) {
            return aDefault;
        }
        return (CTargetAddress)slot.getValue();
    }

    public static Color getForeground(@NotNull CRecord aRecord, Color aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_FOREGROUND);
        if (slot == null) {
            return aDefault;
        }
        return (Color)slot.getValue();
    }

    public static int getPanelType(@NotNull CRecord aRecord, int aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_PANEL_TYPE);
        if (slot == null) {
            return aDefault;
        }
        return (Integer)slot.getValue();
    }

    public static void setBackground(@NotNull CRecord aRecord, Color aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.COLOR, (Object)aValue);
        aRecord.addSlot(SLOT_BACKGROUND, slot);
    }

    public static void setCenterDlgAbove(@NotNull CRecord aRecord, CWidgetId aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.WIDGET_ID, (Object)aValue);
        aRecord.addSlot(SLOT_CENTER_DLG_ABOVE, slot);
    }

    public static void setDialogTargetAddress(@NotNull CRecord aRecord, CTargetAddress aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.TARGET_ADDRESS, (Object)aValue);
        aRecord.addSlot(SLOT_DIALOG_TARGET_ADDRESS, slot);
    }

    public static void setForeground(@NotNull CRecord aRecord, Color aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.COLOR, (Object)aValue);
        aRecord.addSlot(SLOT_FOREGROUND, slot);
    }

    public static void setPanelType(@NotNull CRecord aRecord, int aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.INT, (Object)aValue);
        aRecord.addSlot(SLOT_PANEL_TYPE, slot);
    }
}

