/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.remoteskin.server.dialog;

import de.sillysky.nyssr.address.CNodeAddress;
import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.common.CWellKnownNID;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.namespace.INamespace;
import de.sillysky.nyssr.namespace.INamespaceRegistry;
import de.sillysky.nyssr.nanoservice.INanoServiceRegistry;
import de.sillysky.nyssr.notification.records.CRecordNotifyRemoteNodeRemoved;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.remoteskin.server.context.IRemoteSkinServerContext;
import de.sillysky.nyssr.remoteskin.server.context.IRemoteSkinServerContextFactory;
import de.sillysky.nyssr.remoteskin.server.dialog.CDialogDto;
import de.sillysky.nyssr.remoteskin.server.dialog.records.CRecordCloseDialog;
import de.sillysky.nyssr.remoteskin.server.dialog.records.CRecordNotifyDialogClosed2;
import de.sillysky.nyssr.remoteskin.server.widgetset.loader.IWidgetSetLoader;
import de.sillysky.nyssr.target.CTarget;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public abstract class CBasicDialog
extends CTarget {
    private final CDialogDto mDialogDto;
    private final INamespaceRegistry mNamespaceRegistry;
    private final IRemoteSkinServerContextFactory mRemoteSkinServerContextFactory;
    private final IWidgetSetLoader mWidgetSetLoader;

    public CBasicDialog(@NotNull INamespaceRegistry aNamespaceRegistry, @NotNull IRemoteSkinServerContextFactory aRemoteSkinServerContextFactory, @NotNull IWidgetSetLoader aWidgetSetLoader, @NotNull CDialogDto aDialogDto) {
        this.mNamespaceRegistry = aNamespaceRegistry;
        this.mRemoteSkinServerContextFactory = aRemoteSkinServerContextFactory;
        this.mWidgetSetLoader = aWidgetSetLoader;
        this.mDialogDto = aDialogDto;
        this.addMessageHandler(CRecordCloseDialog.ID, this::asyncCloseDialog);
        this.addMessageHandler(CRecordNotifyRemoteNodeRemoved.ID, this::asyncNotifyRemoteNodeRemoved);
    }

    protected void startTarget(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (!aEnvelope.isAnswer()) {
            INamespace ns = this.mNamespaceRegistry.getNamespace(CWellKnownNID.SYSTEM);
            INanoServiceRegistry nsr = ns.getNanoServiceRegistry();
            nsr.addObserver(CRecordNotifyRemoteNodeRemoved.class, this.getAddress(), false);
            IRemoteSkinServerContext serverContext = this.mRemoteSkinServerContextFactory.createContext(this.mDialogDto.getClientContext(), this.getAddress().getNID());
            this.mDialogDto.setServerContext(serverContext);
            this.sendJsonFiles();
        }
    }

    private boolean asyncNotifyRemoteNodeRemoved(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        CNodeAddress node = CRecordNotifyRemoteNodeRemoved.getRemoteNode((CRecord)aRecord, null);
        if (node != null) {
            boolean b1 = this.mDialogDto.getClientContext().getTargetAddress().getNodeAddress().equals((Object)node);
            boolean b2 = this.mDialogDto.getOwnerAddress().getNodeAddress().equals((Object)node);
            if (b1 || b2) {
                this.deregisterTarget();
            }
            aEnvelope.setResultSuccess();
        }
        return true;
    }

    private boolean asyncCloseDialog(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        this.deregisterTarget();
        aEnvelope.setResultSuccess();
        return true;
    }

    protected void sendJsonFiles() throws CException {
        String[] files = this.getJsonFiles();
        if (files != null && files.length > 0) {
            ArrayList<String> jsonList = new ArrayList<String>();
            for (String jsonName : files) {
                String json = this.mWidgetSetLoader.loadJson(((Object)((Object)this)).getClass(), jsonName);
                jsonList.add(json);
            }
            this.mDialogDto.getServerContext().pushWidgetSets(jsonList, null);
        }
    }

    protected abstract String[] getJsonFiles();

    public void notifyTargetWillBeRemoved() throws Exception {
        this.informFactory();
        super.notifyTargetWillBeRemoved();
    }

    @NotNull
    public CDialogDto getDialogDto() {
        return this.mDialogDto;
    }

    private void informFactory() throws CException {
        CEnvelope env = CEnvelope.forSingleTarget((CTargetAddress)this.mDialogDto.getFactoryAddress());
        CRecord record = CRecordNotifyDialogClosed2.create();
        CRecordNotifyDialogClosed2.setId(record, this.mDialogDto.getDialogInstanceId());
        this.sendNotification(env, record);
    }
}

