/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.dialog.user;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.widget.CWidgetId;
import de.sillysky.nyssr.id.widget.CWidgetSetId;
import de.sillysky.nyssr.impl.dialog.user.CMainTarget;
import de.sillysky.nyssr.remoteskin.model.events.CEventButtonPressedNotification;
import de.sillysky.nyssr.remoteskin.model.events.CEventTextChangeNotification;
import de.sillysky.nyssr.remoteskin.model.events.CEventWindowNotification;
import de.sillysky.nyssr.remoteskin.server.context.IRemoteSkinServerContext;
import de.sillysky.nyssr.remoteskin.server.context.IWidgetApi;
import de.sillysky.nyssr.remoteskin.server.listeners.IButtonPressedListener;
import de.sillysky.nyssr.remoteskin.server.listeners.IListener;
import de.sillysky.nyssr.remoteskin.server.listeners.ITextChangeListener;
import de.sillysky.nyssr.remoteskin.server.listeners.IWindowClosingListener;
import de.sillysky.nyssr.session.api.CRole;
import java.time.LocalDateTime;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class C707Handler {
    private final CMainTarget mMainTarget;
    private final IWidgetApi mApi;
    private final CWidgetSetId mWs707;
    private final CWidgetId m707Dialog;
    private final CWidgetId m707ButtonOkay;
    private final CWidgetId m707ButtonCancel;
    private final CWidgetId m707TfRoleId;
    private final CWidgetId m707TfDescription;
    private final CWidgetId m707CheckboxProtected;
    private final IRemoteSkinServerContext mServerContext;
    private String mEnteredRoleId = "";
    private String mEnteredDescription = "";
    private boolean mEnteredProtected = false;
    private boolean m707ButtonOkayIsEnabled;
    private boolean m707open;
    private CWidgetId mParentWidget;
    private CRole mRole;
    private boolean mIsNewRole = false;

    public C707Handler(@NotNull CMainTarget aMainTarget, @NotNull IRemoteSkinServerContext aServerContext, @NotNull String aInstance) {
        this.mMainTarget = aMainTarget;
        this.mServerContext = aServerContext;
        this.mApi = this.mServerContext.getWidgetApi();
        this.mWs707 = CWidgetSetId.create((String)"@707_EditRole", (String)aInstance);
        this.m707Dialog = CWidgetId.create((String)"#707_Dialog", (CWidgetSetId)this.mWs707);
        this.mApi.addListener(this.m707Dialog, (IListener)((IWindowClosingListener)this::onDialogClosing));
        this.m707ButtonOkay = CWidgetId.create((String)"#707_ButtonOkay", (CWidgetSetId)this.mWs707);
        this.mApi.addListener(this.m707ButtonOkay, (IListener)((IButtonPressedListener)this::onButtonOkay));
        this.m707ButtonCancel = CWidgetId.create((String)"#707_ButtonCancel", (CWidgetSetId)this.mWs707);
        this.mApi.addListener(this.m707ButtonCancel, (IListener)((IButtonPressedListener)this::onButtonCancel));
        this.m707TfRoleId = CWidgetId.create((String)"#707_TextFieldRoleId", (CWidgetSetId)this.mWs707);
        this.mApi.addListener(this.m707TfRoleId, (IListener)((ITextChangeListener)this::onTextChangeRoleId));
        this.m707TfDescription = CWidgetId.create((String)"#707_TextFieldDescription", (CWidgetSetId)this.mWs707);
        this.mApi.addListener(this.m707TfDescription, (IListener)((ITextChangeListener)this::onTextChangeDescription));
        this.m707CheckboxProtected = CWidgetId.create((String)"#707_CheckboxProtected", (CWidgetSetId)this.mWs707);
        this.mApi.addListener(this.m707CheckboxProtected, (IListener)((IButtonPressedListener)this::onCheckboxProtected));
    }

    private void widgetSetMounted(@NotNull CWidgetSetId aWidgetSetId) {
        if (this.mWs707.equals((Object)aWidgetSetId)) {
            this.m707open = true;
            this.mApi.setText(this.m707TfRoleId, this.mRole.getId());
            this.mApi.setText(this.m707TfDescription, this.mRole.getDescription());
            this.mApi.setSelected(this.m707CheckboxProtected, this.mRole.isProtected());
            if (this.mIsNewRole) {
                this.mApi.setEditable(this.m707TfRoleId, true);
            }
            this.mApi.pack(this.m707Dialog);
            this.mApi.centerWidget(this.m707Dialog, this.mParentWidget);
            this.mApi.setVisible(this.m707Dialog, true);
            this.sendUpdate();
        }
    }

    private void updateButtons() {
        if (this.mIsNewRole) {
            this.enableButtonOkay(!this.mEnteredRoleId.isEmpty());
        } else {
            boolean changed2 = !this.mEnteredDescription.equals(this.mRole.getDescription()) || this.mEnteredProtected != this.mRole.isProtected();
            this.enableButtonOkay(changed2);
        }
    }

    private void enableButtonOkay(boolean aEnabled) {
        if (this.m707ButtonOkayIsEnabled != aEnabled) {
            this.m707ButtonOkayIsEnabled = aEnabled;
            this.mApi.setEnabled(this.m707ButtonOkay, this.m707ButtonOkayIsEnabled);
            this.sendUpdate();
        }
    }

    private void onTextChangeRoleId(@NotNull CEventTextChangeNotification aEvent) {
        this.mEnteredRoleId = aEvent.getText();
        this.updateButtons();
    }

    private void onTextChangeDescription(@NotNull CEventTextChangeNotification aEvent) {
        this.mEnteredDescription = aEvent.getText();
        this.updateButtons();
    }

    private void onCheckboxProtected(@NotNull CEventButtonPressedNotification aEvent) {
        this.mEnteredProtected = aEvent.isSelected();
        this.updateButtons();
    }

    private void onButtonOkay(@NotNull CEventButtonPressedNotification aEvent) throws CException {
        if (this.mIsNewRole) {
            this.mMainTarget.sendCreateRole(new CRole(this.mEnteredRoleId, this.mEnteredDescription, this.mEnteredProtected, "", LocalDateTime.now()));
        } else {
            this.mMainTarget.sendUpdateRoleData(new CRole(this.mRole.getId(), this.mEnteredDescription, this.mEnteredProtected, "", LocalDateTime.now()));
        }
        this.unmount();
    }

    private void onButtonCancel(@NotNull CEventButtonPressedNotification aEvent) {
        this.unmount();
    }

    private void onDialogClosing(@NotNull CEventWindowNotification aWindowEvent) {
        this.unmount();
    }

    void mount(@NotNull CWidgetId aParentWidget, @Nullable CRole aRole) {
        if (!this.m707open) {
            if (aRole == null) {
                this.mRole = new CRole();
                this.mIsNewRole = true;
            } else {
                this.mRole = new CRole(aRole);
                this.mIsNewRole = false;
            }
            this.mParentWidget = aParentWidget;
            this.m707ButtonOkayIsEnabled = false;
            this.mServerContext.mountWidgetSet(this.mWs707, aParentWidget, "#707_PanelBackground", this::widgetSetMounted);
            this.sendUpdate();
        }
    }

    void unmount() {
        if (this.m707open) {
            this.m707open = false;
            this.mApi.unmount(this.m707Dialog);
            this.sendUpdate();
        }
    }

    private void sendUpdate() {
        this.mServerContext.sendUpdate();
    }
}

