/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.network.connection.records;

import de.sillysky.nyssr.address.CNodeAddress;
import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.record.IGeneratedRecord;
import de.sillysky.nyssr.slot.CCommonSlotType;
import de.sillysky.nyssr.slot.CSlotFactoryHelper;
import de.sillysky.nyssr.slot.CSlotType;
import de.sillysky.nyssr.slot.ISlot;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;

public final class CRecordDataConnection
implements IGeneratedRecord {
    public static final IId ID = CIdFactory.fromObject((Object)"365ecaee-0355-471e-a532-58dad3cc9115");
    public static final String NAME = "DataConnection";
    public static final String DESCRIPTION = "A connection record, is used by some messages.";
    public static final String SLOT_CONNECTION_ID = "1";
    public static final String SLOT_CONNECTION_TYPE = "2";
    public static final String SLOT_CONNECTION_USAGE = "3";
    public static final String SLOT_INCOMING = "4";
    public static final String SLOT_LOCAL_ADDRESS = "5";
    public static final String SLOT_REMOTE_ADDRESS = "6";
    public static final String SLOT_REMOTE_INSTANCE_ID = "8";
    public static final String SLOT_REMOTE_NODE_ADDRESS = "7";
    public static final String SLOT_TARGET_ADDRESS = "9";
    public static final String[] NAMESPACES = new String[0];
    public static final boolean IS_NANO_SERVICE = false;

    @NotNull
    public static CRecord create() {
        return new CRecord(ID);
    }

    public static UUID getConnectionId(@NotNull CRecord aRecord, UUID aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_CONNECTION_ID);
        if (slot == null) {
            return aDefault;
        }
        return (UUID)slot.getValue();
    }

    public static String getConnectionType(@NotNull CRecord aRecord, String aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_CONNECTION_TYPE);
        if (slot == null) {
            return aDefault;
        }
        return (String)slot.getValue();
    }

    public static String getConnectionUsage(@NotNull CRecord aRecord, String aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_CONNECTION_USAGE);
        if (slot == null) {
            return aDefault;
        }
        return (String)slot.getValue();
    }

    public static boolean getIncoming(@NotNull CRecord aRecord, boolean aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_INCOMING);
        if (slot == null) {
            return aDefault;
        }
        return (Boolean)slot.getValue();
    }

    public static String getLocalAddress(@NotNull CRecord aRecord, String aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_LOCAL_ADDRESS);
        if (slot == null) {
            return aDefault;
        }
        return (String)slot.getValue();
    }

    public static String getRemoteAddress(@NotNull CRecord aRecord, String aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_REMOTE_ADDRESS);
        if (slot == null) {
            return aDefault;
        }
        return (String)slot.getValue();
    }

    public static UUID getRemoteInstanceId(@NotNull CRecord aRecord, UUID aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_REMOTE_INSTANCE_ID);
        if (slot == null) {
            return aDefault;
        }
        return (UUID)slot.getValue();
    }

    public static CNodeAddress getRemoteNodeAddress(@NotNull CRecord aRecord, CNodeAddress aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_REMOTE_NODE_ADDRESS);
        if (slot == null) {
            return aDefault;
        }
        return (CNodeAddress)slot.getValue();
    }

    public static CTargetAddress getTargetAddress(@NotNull CRecord aRecord, CTargetAddress aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_TARGET_ADDRESS);
        if (slot == null) {
            return aDefault;
        }
        return (CTargetAddress)slot.getValue();
    }

    public static void setConnectionId(@NotNull CRecord aRecord, UUID aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.UUID, (Object)aValue);
        aRecord.addSlot(SLOT_CONNECTION_ID, slot);
    }

    public static void setConnectionType(@NotNull CRecord aRecord, String aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.STRING, (Object)aValue);
        aRecord.addSlot(SLOT_CONNECTION_TYPE, slot);
    }

    public static void setConnectionUsage(@NotNull CRecord aRecord, String aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.STRING, (Object)aValue);
        aRecord.addSlot(SLOT_CONNECTION_USAGE, slot);
    }

    public static void setIncoming(@NotNull CRecord aRecord, boolean aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.BOOLEAN, (Object)aValue);
        aRecord.addSlot(SLOT_INCOMING, slot);
    }

    public static void setLocalAddress(@NotNull CRecord aRecord, String aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.STRING, (Object)aValue);
        aRecord.addSlot(SLOT_LOCAL_ADDRESS, slot);
    }

    public static void setRemoteAddress(@NotNull CRecord aRecord, String aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.STRING, (Object)aValue);
        aRecord.addSlot(SLOT_REMOTE_ADDRESS, slot);
    }

    public static void setRemoteInstanceId(@NotNull CRecord aRecord, UUID aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.UUID, (Object)aValue);
        aRecord.addSlot(SLOT_REMOTE_INSTANCE_ID, slot);
    }

    public static void setRemoteNodeAddress(@NotNull CRecord aRecord, CNodeAddress aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.NODE_ADDRESS, (Object)aValue);
        aRecord.addSlot(SLOT_REMOTE_NODE_ADDRESS, slot);
    }

    public static void setTargetAddress(@NotNull CRecord aRecord, CTargetAddress aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.TARGET_ADDRESS, (Object)aValue);
        aRecord.addSlot(SLOT_TARGET_ADDRESS, slot);
    }
}

