/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.network.records;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.record.IGeneratedRecord;
import de.sillysky.nyssr.slot.CCommonSlotType;
import de.sillysky.nyssr.slot.CSlotFactoryHelper;
import de.sillysky.nyssr.slot.CSlotType;
import de.sillysky.nyssr.slot.ISlot;
import org.jetbrains.annotations.NotNull;

public final class CRecordNetworkNotifyConnectionRegistryAvailable
implements IGeneratedRecord {
    public static final IId ID = CIdFactory.fromObject((Object)"6af2b4df-bee0-4e29-8d48-0034e42ff026");
    public static final String NAME = "NetworkNotifyConnectionRegistryAvailable";
    public static final String DESCRIPTION = "Notification that the connection registry is now available (or not).";
    public static final String SLOT_AVAILABLE = "AV";
    public static final String[] NAMESPACES = new String[]{"SYSTEM"};
    public static final boolean IS_NANO_SERVICE = true;

    @NotNull
    public static CRecord create() {
        return new CRecord(ID);
    }

    public static boolean getAvailable(@NotNull CRecord aRecord, boolean aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_AVAILABLE);
        if (slot == null) {
            return aDefault;
        }
        return (Boolean)slot.getValue();
    }

    public static void setAvailable(@NotNull CRecord aRecord, boolean aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.BOOLEAN, (Object)aValue);
        aRecord.addSlot(SLOT_AVAILABLE, slot);
    }
}

