/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.tcp.records;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.record.IGeneratedRecord;
import de.sillysky.nyssr.slot.CCommonSlotType;
import de.sillysky.nyssr.slot.CSlotFactoryHelper;
import de.sillysky.nyssr.slot.CSlotType;
import de.sillysky.nyssr.slot.ISlot;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;

public final class CRecordTcpCreateClient
implements IGeneratedRecord {
    public static final IId ID = CIdFactory.fromObject((Object)"82c787b3-4541-4928-bff4-5862291a837e");
    public static final String NAME = "TcpCreateClient";
    public static final String DESCRIPTION = "Create and start a TCP client.";
    public static final String SLOT_FAIL_ON_FIRST_CONNECT = "9";
    public static final String SLOT_HOST = "2";
    public static final String SLOT_ID = "1";
    public static final String SLOT_INPUT_BUFFER_SIZE = "7";
    public static final String SLOT_PORT = "3";
    public static final String SLOT_RETRY_TIMEOUT = "8";
    public static final String SLOT_TLS_CIPHER_SUITES = "6";
    public static final String SLOT_TLS_ENABLED = "4";
    public static final String SLOT_TLS_PROTOCOLS = "5";
    public static final String SLOT_WANT_UPDATE_ON_RETRY = "10";
    public static final String[] NAMESPACES = new String[]{"SYSTEM"};
    public static final boolean IS_NANO_SERVICE = true;

    @NotNull
    public static CRecord create() {
        return new CRecord(ID);
    }

    public static boolean getFailOnFirstConnect(@NotNull CRecord aRecord, boolean aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_FAIL_ON_FIRST_CONNECT);
        if (slot == null) {
            return aDefault;
        }
        return (Boolean)slot.getValue();
    }

    public static String getHost(@NotNull CRecord aRecord, String aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_HOST);
        if (slot == null) {
            return aDefault;
        }
        return (String)slot.getValue();
    }

    public static UUID getId(@NotNull CRecord aRecord, UUID aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_ID);
        if (slot == null) {
            return aDefault;
        }
        return (UUID)slot.getValue();
    }

    public static int getInputBufferSize(@NotNull CRecord aRecord, int aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_INPUT_BUFFER_SIZE);
        if (slot == null) {
            return aDefault;
        }
        return (Integer)slot.getValue();
    }

    public static int getPort(@NotNull CRecord aRecord, int aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_PORT);
        if (slot == null) {
            return aDefault;
        }
        return (Integer)slot.getValue();
    }

    public static long getRetryTimeout(@NotNull CRecord aRecord, long aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_RETRY_TIMEOUT);
        if (slot == null) {
            return aDefault;
        }
        return (Long)slot.getValue();
    }

    public static String getTlsCipherSuites(@NotNull CRecord aRecord, String aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_TLS_CIPHER_SUITES);
        if (slot == null) {
            return aDefault;
        }
        return (String)slot.getValue();
    }

    public static boolean getTlsEnabled(@NotNull CRecord aRecord, boolean aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_TLS_ENABLED);
        if (slot == null) {
            return aDefault;
        }
        return (Boolean)slot.getValue();
    }

    public static String getTlsProtocols(@NotNull CRecord aRecord, String aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_TLS_PROTOCOLS);
        if (slot == null) {
            return aDefault;
        }
        return (String)slot.getValue();
    }

    public static boolean getWantUpdateOnRetry(@NotNull CRecord aRecord, boolean aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_WANT_UPDATE_ON_RETRY);
        if (slot == null) {
            return aDefault;
        }
        return (Boolean)slot.getValue();
    }

    public static void setFailOnFirstConnect(@NotNull CRecord aRecord, boolean aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.BOOLEAN, (Object)aValue);
        aRecord.addSlot(SLOT_FAIL_ON_FIRST_CONNECT, slot);
    }

    public static void setHost(@NotNull CRecord aRecord, String aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.STRING, (Object)aValue);
        aRecord.addSlot(SLOT_HOST, slot);
    }

    public static void setId(@NotNull CRecord aRecord, UUID aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.UUID, (Object)aValue);
        aRecord.addSlot(SLOT_ID, slot);
    }

    public static void setInputBufferSize(@NotNull CRecord aRecord, int aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.INT, (Object)aValue);
        aRecord.addSlot(SLOT_INPUT_BUFFER_SIZE, slot);
    }

    public static void setPort(@NotNull CRecord aRecord, int aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.INT, (Object)aValue);
        aRecord.addSlot(SLOT_PORT, slot);
    }

    public static void setRetryTimeout(@NotNull CRecord aRecord, long aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.LONG, (Object)aValue);
        aRecord.addSlot(SLOT_RETRY_TIMEOUT, slot);
    }

    public static void setTlsCipherSuites(@NotNull CRecord aRecord, String aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.STRING, (Object)aValue);
        aRecord.addSlot(SLOT_TLS_CIPHER_SUITES, slot);
    }

    public static void setTlsEnabled(@NotNull CRecord aRecord, boolean aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.BOOLEAN, (Object)aValue);
        aRecord.addSlot(SLOT_TLS_ENABLED, slot);
    }

    public static void setTlsProtocols(@NotNull CRecord aRecord, String aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.STRING, (Object)aValue);
        aRecord.addSlot(SLOT_TLS_PROTOCOLS, slot);
    }

    public static void setWantUpdateOnRetry(@NotNull CRecord aRecord, boolean aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.BOOLEAN, (Object)aValue);
        aRecord.addSlot(SLOT_WANT_UPDATE_ON_RETRY, slot);
    }
}

