/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.address;

import de.sillysky.nyssr.address.CNodeId;
import de.sillysky.nyssr.util.CPositiveInteger;
import de.sillysky.nyssr.util.CUtilRandom;
import de.sillysky.nyssr.util.CUtilStringArray;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CUtilNodeIdArray {
    public static final CNodeId[] EMPTY = new CNodeId[0];

    private CUtilNodeIdArray() {
    }

    public static boolean contains(@Nullable CNodeId aNodeId, CNodeId @Nullable [] aArray) {
        if (aArray != null && aNodeId != null) {
            for (CNodeId nodeId : aArray) {
                if (!aNodeId.equals(nodeId)) continue;
                return true;
            }
        }
        return false;
    }

    public static CNodeId[] fromList(@Nullable List<?> aList) {
        if (aList == null || aList.isEmpty()) {
            return EMPTY;
        }
        ArrayList<CNodeId> list = new ArrayList<CNodeId>();
        for (Object element : aList) {
            CNodeId id;
            if (element == null) continue;
            if (element instanceof CNodeId) {
                id = (CNodeId)element;
                list.add(id);
                continue;
            }
            if (element instanceof CNodeId[]) {
                CNodeId[] ids = (CNodeId[])element;
                Collections.addAll(list, ids);
                continue;
            }
            id = CNodeId.fromObject(element);
            list.add(id);
        }
        CNodeId[] arr = new CNodeId[list.size()];
        int i = 0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            CNodeId id;
            arr[i] = id = (CNodeId)iterator.next();
            ++i;
        }
        return arr;
    }

    @Nullable
    public static @Nullable CNodeId @Nullable [] fromStream(@NotNull DataInput aStream) throws IOException {
        int len = CPositiveInteger.fromStream(aStream);
        if (len == 0) {
            return null;
        }
        CNodeId[] array = new CNodeId[len - 1];
        for (int i = 0; i < len - 1; ++i) {
            array[i] = CNodeId.fromStream(aStream);
        }
        return array;
    }

    public static CNodeId[] fromString(@Nullable String aValue) {
        String[] stringArray = CUtilStringArray.fromString(aValue);
        return CUtilNodeIdArray.fromStringArray(stringArray);
    }

    private static CNodeId[] fromStringArray(@Nullable String[] aList) {
        if (aList == null || aList.length == 0) {
            return EMPTY;
        }
        CNodeId[] array = new CNodeId[aList.length];
        int i = 0;
        for (String element : aList) {
            array[i] = CNodeId.fromObject(element);
            ++i;
        }
        return array;
    }

    public static CNodeId @Nullable [] copy(CNodeId @Nullable [] aValue) {
        if (aValue == null) {
            return null;
        }
        return Arrays.copyOf(aValue, aValue.length);
    }

    public static boolean isEqual(CNodeId @Nullable [] aValue1, CNodeId @Nullable [] aValue2) {
        if (aValue1 == null) {
            return aValue2 == null;
        }
        if (aValue2 == null) {
            return false;
        }
        for (int i = 0; i < aValue1.length; ++i) {
            if (CNodeId.equals(aValue1[i], aValue2[i])) continue;
            return false;
        }
        return true;
    }

    public static void toStream(@NotNull DataOutput aStream, @Nullable @Nullable CNodeId @Nullable [] aValue) throws IOException {
        if (aValue == null) {
            CPositiveInteger.toStream(aStream, 0);
        } else {
            CPositiveInteger.toStream(aStream, aValue.length + 1);
            for (CNodeId element : aValue) {
                CNodeId.toStream(aStream, element);
            }
        }
    }

    @NotNull
    public static String toString(CNodeId @Nullable [] aValue) {
        if (aValue == null || aValue.length == 0) {
            return "";
        }
        String[] arr = new String[aValue.length];
        for (int i = 0; i < aValue.length; ++i) {
            arr[i] = aValue[i].valueToString();
        }
        return CUtilStringArray.toStringWithPipe(arr);
    }

    public static void toStringList(CNodeId @Nullable [] aValue, @NotNull List<String> aList) {
        if (aValue != null && aValue.length > 0) {
            for (CNodeId element : aValue) {
                String s = element.valueToString();
                aList.add(s);
            }
        }
    }

    public static CNodeId @NotNull [] random(int aSize, boolean aWithNullValues) {
        CNodeId[] arr = new CNodeId[aSize];
        for (int i = 0; i < aSize; ++i) {
            boolean b = CUtilRandom.getRandom().nextBoolean();
            if (!b && aWithNullValues) continue;
            arr[i] = CNodeId.random();
        }
        return arr;
    }
}

