/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.copyright;

import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.util.CUtilString;
import de.sillysky.nyssr.util.CUtilUuid;
import de.sillysky.nyssr.util.resources.CUtilResources;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class CPanelCopyright
extends JPanel {
    private static final ILogger LOG = CLoggerFactory.getLogger(CPanelCopyright.class);
    private static final float ALIGNMENT = 0.5f;
    private static final int GAP_HORZ = 20;
    private static final int GAP_VERT1 = 30;
    private static final int GAP_VERT2 = 50;
    private static final int GAP_VERT3 = 20;
    private static final int GAP_VERT4 = 14;
    private static final int HTML_WIDTH = 1000;
    private static final int FONT_SIZE = 14;
    private static final int EDIT_WIDTH_PLUS = 50;
    private final UUID mLicense;
    private JTextPane mHtmlPane;

    CPanelCopyright(UUID aLicense) {
        this.mLicense = aLicense;
        this.setBackground(Color.WHITE);
        this.setLayout(new BoxLayout(this, 1));
        this.add(Box.createVerticalStrut(30));
        this.initLogoHorz(this);
        this.add(Box.createVerticalStrut(50));
        this.initHtml(this);
        this.add(Box.createVerticalStrut(20));
    }

    @Nullable
    private ImageIcon createImageIcon(@NotNull String aPath, @NotNull String aDescription) {
        URL imgURL = this.getClass().getClassLoader().getResource(aPath);
        if (imgURL != null) {
            return new ImageIcon(imgURL, aDescription);
        }
        LOG.error("Couldn't find file: " + aPath);
        return null;
    }

    private void generate() {
        String html = CUtilResources.readTextFile(this.getClass(), "/license.html", StandardCharsets.UTF_8);
        if (CUtilString.isEmpty(html)) {
            StringBuilder sb = new StringBuilder(5000);
            sb.append("<HTML>");
            sb.append("<BODY>");
            sb.append("<b>License file not found.</b>");
            sb.append("</BODY>");
            sb.append("</HTML>");
            html = sb.toString();
        }
        this.mHtmlPane.setText(html);
    }

    private void initHtml(Container aParent) {
        Box box = Box.createHorizontalBox();
        this.mHtmlPane = new JTextPane();
        HTMLEditorKit eKit = new HTMLEditorKit();
        this.mHtmlPane.setContentType("text/html");
        this.mHtmlPane.setFont(new Font("Verdana", 0, 14));
        JScrollPane scroller = new JScrollPane(this.mHtmlPane);
        Dimension dim = this.mHtmlPane.getMaximumSize();
        dim.width = 1000;
        scroller.setMaximumSize(dim);
        scroller.setBorder(null);
        StyleSheet ss = new StyleSheet();
        ss.addRule("table {border-spacing:1px}");
        eKit.setStyleSheet(ss);
        this.mHtmlPane.setEditorKit(eKit);
        this.generate();
        box.add(Box.createHorizontalStrut(20));
        box.add(scroller);
        box.add(Box.createHorizontalStrut(20));
        aParent.add(box);
    }

    private void initLogoHorz(Container aParent) {
        Box box = Box.createHorizontalBox();
        box.add(Box.createHorizontalGlue());
        this.initLogoVert(box);
        box.add(Box.createHorizontalGlue());
        aParent.add(box);
    }

    private void initLogoVert(Container aParent) {
        ImageIcon icon = this.createImageIcon("images/softdevel.gif", "sillysky");
        JLabel labelIcon = new JLabel(icon);
        labelIcon.setAlignmentX(0.5f);
        JLabel labelClaim = new JLabel("Don't limit your fantasies.");
        labelClaim.setAlignmentX(0.5f);
        Font font = new Font("Arial bold", 2, 20);
        labelClaim.setFont(font);
        labelClaim.setForeground(Color.red);
        String txt = this.mLicense == null ? "No License" : "License: " + CUtilUuid.toString(this.mLicense);
        JTextField tf = new JTextField(txt);
        tf.setEditable(false);
        tf.setAlignmentX(0.5f);
        tf.setBackground(Color.white);
        tf.setBorder(null);
        Dimension dim = tf.getPreferredSize();
        dim.width += 50;
        tf.setMaximumSize(dim);
        tf.setHorizontalAlignment(0);
        Box box = Box.createVerticalBox();
        box.add(labelIcon);
        box.add(Box.createVerticalStrut(14));
        box.add(labelClaim);
        box.add(Box.createVerticalStrut(14));
        box.add(tf);
        aParent.add(box);
    }
}

