/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.job;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.impl.job.CJobEngine;
import de.sillysky.nyssr.job.EJobStatus;
import de.sillysky.nyssr.job.IJob;
import de.sillysky.nyssr.job.IJobThread;
import de.sillysky.nyssr.job.records.CRecordNotifyJobFinished;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.message.queue.IMessageQueue;
import de.sillysky.nyssr.message.queue.IMessageQueueRegistry;
import de.sillysky.nyssr.namespace.INamespace;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.thread.EThreadPriority;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;

public class CJobThread
implements IJobThread {
    private final CJobEngine mJobEngine;
    private final INamespace mNamespace;
    private final String mName;
    private final EThreadPriority mPriority;
    private final int mMaxConcurrentJobs;
    private final IId mQueueId;
    private final IMessageQueue mQueue;
    private final Map<UUID, IJob> mJobs;

    public CJobThread(@NotNull CJobEngine aJobEngine, @NotNull INamespace aNamespace, @NotNull String aName, @NotNull EThreadPriority aPriority, int aMaxConcurrentJobs) throws CException {
        this.mJobEngine = aJobEngine;
        this.mNamespace = aNamespace;
        this.mName = aName;
        this.mPriority = aPriority;
        this.mMaxConcurrentJobs = aMaxConcurrentJobs;
        this.mJobs = new ConcurrentHashMap<UUID, IJob>();
        this.mQueueId = this.mNamespace.createThread(aJobEngine.getName() + "-" + this.mName, this.mPriority);
        IMessageQueueRegistry mqr = this.mNamespace.getMessageQueueRegistry();
        this.mQueue = mqr.getQueue(this.mQueueId);
    }

    @Override
    public int getQueueSize() {
        return this.mQueue.getSize();
    }

    @Override
    public int getJobCount() {
        return this.mJobs.size();
    }

    @NotNull
    IId getQueueId() {
        return this.mQueueId;
    }

    @Override
    public void notifyJobFinished(@NotNull IJob aJob) throws CException {
        UUID id = aJob.getId();
        this.stopJob(id);
    }

    private void sendJobFinished(@NotNull IJob aJob) throws CException {
        CEnvelope env = CEnvelope.forSingleTarget(this.mJobEngine.getAddress());
        CRecord record = CRecordNotifyJobFinished.create();
        CRecordNotifyJobFinished.setThreadQueueId(record, this.mQueueId);
        CRecordNotifyJobFinished.setJobName(record, aJob.getJobName());
        CRecordNotifyJobFinished.setElapsedTime(record, aJob.getMilliSecondsElapsed());
        this.mJobEngine.sendNotification(env, record);
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    @NotNull
    public EThreadPriority getPriority() {
        return this.mPriority;
    }

    void startJob(@NotNull IJob aJob) throws CException {
        UUID id = aJob.getId();
        if (!this.mJobs.containsKey(id)) {
            this.mJobs.put(id, aJob);
            aJob.notifyJobStarted(this);
            IId tid = CIdFactory.fromObject(id);
            this.mNamespace.getTargetRegistry().registerTarget(aJob.getTarget(), tid, this.mQueueId);
        }
    }

    @Override
    public int getMaxConcurrentJobs() {
        return this.mMaxConcurrentJobs;
    }

    boolean stopJob(@NotNull UUID aJobId) throws CException {
        IJob job = this.mJobs.remove(aJobId);
        if (job != null) {
            job.setStatus(EJobStatus.DETACHED);
            job.getTarget().deregisterTarget();
            this.sendJobFinished(job);
        }
        return false;
    }

    public String toString() {
        return "JobThread " + this.mName + ": JobCount=" + this.getJobCount();
    }
}

