/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.json.writer;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.impl.json.writer.IDependencies;
import de.sillysky.nyssr.json.CJsonArray;
import de.sillysky.nyssr.json.CJsonObject;
import de.sillysky.nyssr.json.IJsonBeautifier;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.util.string.builder.CStringBuilder;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

class CJsonBeautifier
implements IService,
IJsonBeautifier {
    @NotNull
    private final IDependencies mDependencies;

    public CJsonBeautifier(@NotNull IDependencies aDependencies) {
        this.mDependencies = aDependencies;
    }

    @Override
    public void activate(@NotNull IServiceRegistry aServiceRegistry) {
        aServiceRegistry.registerService(IJsonBeautifier.class, this);
    }

    @Override
    @NotNull
    public String beautify(@NotNull String aText) throws CException {
        CStringBuilder sb = new CStringBuilder();
        CJsonObject obj = this.mDependencies.getJsonParser().parse(aText, false);
        this.beautify(sb, obj);
        return sb.toString();
    }

    @Override
    public void deactivate(@NotNull IServiceRegistry aServiceRegistry) {
        aServiceRegistry.deregisterService(this);
    }

    @Override
    public void beautify(@NotNull CStringBuilder aSb, @NotNull Object aObject) {
        if (aObject instanceof CJsonObject) {
            this.writeObject(aSb, (CJsonObject)aObject);
        } else if (aObject instanceof CJsonArray) {
            CJsonArray array = (CJsonArray)aObject;
            this.writeArray(aSb, array);
        } else if (aObject instanceof Boolean || aObject instanceof Number) {
            aSb.append(aObject.toString());
        } else {
            aSb.append('\"').append((String)aObject).append('\"');
        }
    }

    private void writeArray(@NotNull CStringBuilder aSb, @NotNull CJsonArray aArray) {
        aSb.append('[').newLine().inc();
        int size = aArray.size();
        for (int i = 0; i < size; ++i) {
            aSb.appendTab();
            Object o = aArray.getValue(i);
            this.beautify(aSb, o);
            if (i < size - 1) {
                aSb.append(',');
            }
            aSb.newLine();
        }
        aSb.dec().appendTab().append(']');
    }

    private void writeObject(@NotNull CStringBuilder aSb, @NotNull CJsonObject aObj) {
        aSb.append('{').newLine().inc();
        int size = aObj.size();
        int i = 0;
        Collection<String> keys = aObj.keys();
        for (String key : keys) {
            aSb.appendTab().append('\"').append(key).append('\"').append(": ");
            this.beautify(aSb, aObj.getValue(key));
            if (i < size - 1) {
                aSb.append(',');
            }
            aSb.newLine();
            ++i;
        }
        aSb.dec().appendTab().append('}');
    }
}

