/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.log;

import de.sillysky.nyssr.log.CDefaultMessageFormatter;
import de.sillysky.nyssr.log.ELevel;
import de.sillysky.nyssr.log.ILogWriter;
import de.sillysky.nyssr.log.IMessageFormatter;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CAbstractLogWriter
implements ILogWriter {
    private final Map<String, ELevel> mLevels = new HashMap<String, ELevel>();
    private ELevel mLevel = ELevel.INFO;
    private IMessageFormatter mFormatter = new CDefaultMessageFormatter();
    private Path mFilePath;
    private boolean mFileAppend;

    @Override
    public ELevel calcLevel(String aName) {
        Map<String, ELevel> map = this.mLevels;
        synchronized (map) {
            String name = aName;
            while (true) {
                ELevel level;
                if ((level = this.mLevels.get(name)) != null) {
                    return level;
                }
                int index = name.lastIndexOf(46);
                if (index == -1) {
                    return this.mLevel;
                }
                name = name.substring(0, index);
            }
        }
    }

    protected Path getFilePath() {
        return this.mFilePath;
    }

    @Override
    public void setFilePath(Path aPath) {
        this.mFilePath = aPath;
    }

    protected IMessageFormatter getFormatter() {
        return this.mFormatter;
    }

    public Map<String, ELevel> getLoggerLevels() {
        return this.mLevels;
    }

    public ELevel getRootLevel() {
        return this.mLevel;
    }

    protected boolean isFileAppend() {
        return this.mFileAppend;
    }

    @Override
    public void setFileAppend(boolean aAppend) {
        this.mFileAppend = aAppend;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeLevel(@NotNull String aName) {
        Map<String, ELevel> map = this.mLevels;
        synchronized (map) {
            this.mLevels.remove(aName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLevel(@NotNull String aName, @NotNull ELevel aLevel) {
        Map<String, ELevel> map = this.mLevels;
        synchronized (map) {
            this.mLevels.put(aName, aLevel);
        }
    }

    @Override
    public void setLevel(@NotNull ELevel aLevel) {
        this.mLevel = aLevel;
    }

    @Override
    public void setMessageFormatter(@Nullable IMessageFormatter aFormatter) {
        this.mFormatter = aFormatter != null ? aFormatter : new CDefaultMessageFormatter();
    }
}

