/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.message.queue;

import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.message.queue.CAbstractMessageQueue;
import de.sillysky.nyssr.impl.message.queue.CMessageQueueRegistry;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.message.CMessage;
import de.sillysky.nyssr.message.IMessageSender;
import de.sillysky.nyssr.message.IPostMan;
import de.sillysky.nyssr.message.queue.IMessageQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.jetbrains.annotations.NotNull;

class CAsyncMessageQueue
extends CAbstractMessageQueue
implements Runnable,
IMessageQueue {
    private static final ILogger LOG = CLoggerFactory.getLogger(CAsyncMessageQueue.class);
    private static final int MAX_QUEUE_SIZE = 1000;
    private static final int SPEAK = 100;
    private static final int HW_SPEAK = 0;
    private final BlockingQueue<CMessage> mMessageQueue = new LinkedBlockingQueue<CMessage>();
    private final int mThreadPriority;
    private int mMessageCounter = 0;
    private int mMessageCounterSpeaker = 0;
    private int mHighWater = 0;
    private int mHighWaterSpeaker = 0;
    private boolean mRunning = false;
    private Thread mThread = null;
    private boolean mStop;

    CAsyncMessageQueue(CMessageQueueRegistry aRegistry, IMessageSender aMessageSender, IId aQueueId, String aDesc, IPostMan aPostMan, int aThreadPriority) {
        super(aRegistry, aMessageSender, aQueueId, aDesc, aPostMan);
        this.mThreadPriority = aThreadPriority;
    }

    private void checkQueueSize() {
        int size = this.mMessageQueue.size();
        if (size > this.mHighWater) {
            this.mHighWater = size;
            if (this.mHighWaterSpeaker <= 0) {
                this.mHighWaterSpeaker = 0;
                LOG.debug("QueueSize={}", size);
            } else {
                --this.mHighWaterSpeaker;
            }
        }
        if (size > 1000) {
            if (this.mMessageCounterSpeaker <= 0) {
                LOG.warn("Queue={}, QueueSize={}", this.getId(), size);
                this.mMessageCounterSpeaker = 100;
            } else {
                --this.mMessageCounterSpeaker;
            }
            ++this.mMessageCounter;
        } else {
            this.mMessageCounter = 0;
        }
    }

    @Override
    public void dismiss() {
        if (!this.mStop) {
            LOG.info("Try to stop async queue {}", this.toString());
            this.mStop = true;
            this.deregisterMe();
            this.mThread.interrupt();
        }
    }

    @Override
    public boolean equals(Object aObj) {
        return super.equals(aObj);
    }

    @Override
    public int getSize() {
        return this.mMessageQueue.size();
    }

    @Override
    @NotNull
    public Thread getThread() {
        return this.mThread;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public void offer(@NotNull CMessage aMsg) {
        if (!this.mMessageQueue.add(aMsg)) {
            LOG.error("Could not add message to queue.");
        }
    }

    @Override
    public void run() {
        this.mStop = false;
        do {
            try {
                CMessage msg = this.mMessageQueue.take();
                this.checkQueueSize();
                this.dispatchInternal(msg);
            }
            catch (InterruptedException th) {
                this.mStop = true;
            }
            catch (Throwable th) {
                LOG.error("Exception in AsyncMessageQueue.", th);
            }
        } while (!this.mStop);
        this.mRunning = false;
        LOG.info("Okay: Thread {} stopped, description={}.", this.getId(), this.getDescription());
    }

    @Override
    public void start() {
        if (!this.mRunning) {
            this.mRunning = true;
            String sb = "Queue_" + this.getDescription() + "_QID_" + this.getId().valueToString();
            this.mThread = new Thread((Runnable)this, sb);
            this.mThread.start();
            this.mThread.setPriority(this.mThreadPriority);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(70);
        sb.append("Queue ");
        sb.append(this.getId());
        sb.append(" [description=");
        sb.append(this.getDescription());
        sb.append("][priority=");
        sb.append(this.mThreadPriority);
        sb.append("][queue=");
        sb.append(this.mMessageQueue.size());
        sb.append("][Running=");
        sb.append(this.mRunning);
        sb.append("]");
        return sb.toString();
    }
}

