/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.namedb;

import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.namedb.IResultCodeDatabase;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;

final class CResultCodeDatabase
implements IResultCodeDatabase {
    private static final ILogger LOG = CLoggerFactory.getLogger(CResultCodeDatabase.class);
    private static final int MAP_SIZE = 100;
    private final Map<Integer, String> mDb = new ConcurrentHashMap<Integer, String>(100);

    CResultCodeDatabase() {
    }

    @Override
    public void dump() {
        LOG.info("CResultCodeDatabase: size={}", this.mDb.size());
        for (Map.Entry<Integer, String> entry : this.mDb.entrySet()) {
            LOG.trace("{} = {}", entry.getKey(), entry.getValue());
        }
    }

    @Override
    @NotNull
    public String getName(int aResultCode) {
        String name = this.mDb.get(aResultCode);
        if (name == null) {
            name = Integer.toString(aResultCode);
        }
        return name;
    }

    @Override
    public String getNameOrNull(int aResultCode) {
        return this.mDb.get(aResultCode);
    }

    @Override
    public void putName(int aResultCode, @NotNull String aName) {
        this.mDb.put(aResultCode, aName);
    }

    @Override
    public void removeName(int aResultCode) {
        this.mDb.remove(aResultCode);
    }
}

