/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.namespace.registry;

import de.sillysky.nyssr.address.CNodeId;
import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.exception.CUtilCheck;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.id.common.CWellKnownNID;
import de.sillysky.nyssr.id.common.CWellKnownTID;
import de.sillysky.nyssr.impl.namespace.monitor.IPrivateNamespaceMonitor;
import de.sillysky.nyssr.impl.namespace.registry.IDependencies;
import de.sillysky.nyssr.impl.namespace.registry.INamespaceListener;
import de.sillysky.nyssr.impl.service.CServiceRegistry;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.message.IMessageSender;
import de.sillysky.nyssr.namespace.INamespace;
import de.sillysky.nyssr.namespace.INamespaceInternal;
import de.sillysky.nyssr.namespace.INamespaceRegistry;
import de.sillysky.nyssr.notification.records.CRecordNotifyNamespaceDeregistered;
import de.sillysky.nyssr.notification.records.CRecordNotifyNamespaceRegistered;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.record.helper.CRecordHelper;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.util.CUtilString;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class CNamespaceRegistry
implements INamespaceRegistry,
IService {
    private static final ILogger LOG = CLoggerFactory.getLogger(CNamespaceRegistry.class);
    private static final int HASH_MAP_SIZE = 10;
    private final Map<IId, INamespace> mNamespaces = new ConcurrentHashMap<IId, INamespace>(10);
    private final Set<INamespaceListener> mNamespaceListeners = new CopyOnWriteArraySet<INamespaceListener>();
    private final IDependencies mDependencies;
    private CTargetAddress mMyAddress;

    public CNamespaceRegistry(IDependencies aDependencies) {
        this.mDependencies = aDependencies;
    }

    @Override
    public void activate(@NotNull IServiceRegistry aServiceRegistry) {
        this.mMyAddress = new CTargetAddress(CWellKnownTID.NAMESPACE_REGISTRY, CWellKnownNID.SYSTEM, this.mDependencies.getKernelConfiguration().getNodeAddress());
        aServiceRegistry.registerService(INamespaceRegistry.class, this);
        CRecordHelper.init(this);
    }

    @Override
    public void addListener(@NotNull INamespaceListener aListener) {
        this.mNamespaceListeners.add(aListener);
    }

    @Override
    public void deactivate(@NotNull IServiceRegistry aServiceRegistry) {
        aServiceRegistry.deregisterService(this);
    }

    @Override
    public void deregisterNamespace(@NotNull IId aNID) {
        CUtilCheck.checkNotNull(aNID, "Missing Namespace ID", new Object[0]);
        INamespace ns = this.mNamespaces.remove(aNID);
        if (ns == null) {
            LOG.warn("Namespace {} not found.", aNID);
        } else {
            this.dump();
        }
        this.sendNotifyNamespaceRemoved(aNID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exist(@Nullable IId aNID) {
        boolean result = false;
        if (aNID != null) {
            Map<IId, INamespace> map = this.mNamespaces;
            synchronized (map) {
                result = this.mNamespaces.containsKey(aNID);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public INamespace getNamespace(@NotNull IId aNID) {
        INamespace ns;
        Map<IId, INamespace> map = this.mNamespaces;
        synchronized (map) {
            ns = this.mNamespaces.get(aNID);
        }
        return ns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public IId[] getNamespaceIDs() {
        Map<IId, INamespace> map = this.mNamespaces;
        synchronized (map) {
            int size = this.mNamespaces.size();
            IId[] arr = new IId[size];
            arr = this.mNamespaces.keySet().toArray(arr);
            return arr;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public INamespace[] getNamespaces() {
        Map<IId, INamespace> map = this.mNamespaces;
        synchronized (map) {
            int size = this.mNamespaces.size();
            INamespace[] arr = new INamespace[size];
            arr = this.mNamespaces.values().toArray(arr);
            return arr;
        }
    }

    @Override
    @NotNull
    public CNodeId getNodeId() {
        return this.mMyAddress.getNodeId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerNamespace(@NotNull IId aNID, @NotNull INamespace aNamespace) {
        Map<IId, INamespace> map = this.mNamespaces;
        synchronized (map) {
            INamespace ns = this.mNamespaces.get(aNID);
            if (ns != null) {
                LOG.error("Namespace {} already registered.", aNID);
                return;
            }
            this.mNamespaces.put(aNID, aNamespace);
            this.dump();
            ((INamespaceInternal)((Object)aNamespace)).notifyRegistered();
        }
        this.sendNotifyNamespaceRegistered(aNID);
    }

    @Override
    public void removeListener(@NotNull INamespaceListener aListener) {
        this.mNamespaceListeners.remove(aListener);
    }

    private void sendNotifyNamespaceRemoved(IId aNID) {
        this.sendRemoveNotificationViaMonitor(aNID);
        this.sendAsyncRemoveNotification(aNID);
        this.sendSyncRemoveNotification(aNID);
    }

    private void sendRemoveNotificationViaMonitor(IId aNID) {
        IPrivateNamespaceMonitor monitor = CServiceRegistry.getInstance().getService(IPrivateNamespaceMonitor.class);
        if (monitor != null) {
            try {
                monitor.triggerNamespaceDeregistered(aNID);
            }
            catch (CException e) {
                LOG.error("Couldn't send Monitor Notification for deregister namespace {}", aNID);
            }
        }
    }

    private void sendSyncRemoveNotification(IId aNID) {
        for (INamespaceListener l : this.mNamespaceListeners) {
            try {
                l.notifyNamespaceDeregistered(aNID);
            }
            catch (Exception exception) {}
        }
    }

    private void sendAsyncRemoveNotification(IId aNID) {
        IMessageSender messageSender = CServiceRegistry.getInstance().getService(IMessageSender.class);
        if (messageSender != null) {
            try {
                CEnvelope env = CEnvelope.forLocalNanoService(CRecordNotifyNamespaceDeregistered.class);
                env.setSender(this.mMyAddress);
                CRecord rec = CRecordNotifyNamespaceDeregistered.create();
                CRecordNotifyNamespaceDeregistered.setNamespace(rec, aNID);
                messageSender.sendNotification(env, rec);
            }
            catch (CException cException) {
                // empty catch block
            }
        }
    }

    private void sendNotifyNamespaceRegistered(IId aNID) {
        this.sendAddNotificationViaMonitor(aNID);
        this.sendAsyncAddNotification(aNID);
        this.sendSyncAddNotification(aNID);
    }

    private void sendSyncAddNotification(IId aNID) {
        for (INamespaceListener l : this.mNamespaceListeners) {
            try {
                l.notifyNamespaceRegistered(aNID);
            }
            catch (Exception exception) {}
        }
    }

    private void sendAsyncAddNotification(IId aNID) {
        IMessageSender messageSender = CServiceRegistry.getInstance().getService(IMessageSender.class);
        if (messageSender != null) {
            try {
                CEnvelope env = CEnvelope.forLocalNanoService(CRecordNotifyNamespaceRegistered.class);
                env.setSender(this.mMyAddress);
                CRecord rec = CRecordNotifyNamespaceRegistered.create();
                CRecordNotifyNamespaceRegistered.setNamespace(rec, aNID);
                messageSender.sendNotification(env, rec);
            }
            catch (CException cException) {
                // empty catch block
            }
        }
    }

    private void sendAddNotificationViaMonitor(IId aNID) {
        IPrivateNamespaceMonitor monitor = CServiceRegistry.getInstance().getService(IPrivateNamespaceMonitor.class);
        if (monitor != null) {
            try {
                monitor.triggerNamespaceRegistered(aNID);
            }
            catch (CException e) {
                LOG.error("Couldn't send Monitor Notification for register namespace {}", aNID);
            }
        }
    }

    @Override
    public void dump() {
        if (LOG.isDebugEnabled()) {
            LOG.debug(this.getDump());
        }
    }

    @Override
    @NotNull
    public String getDump() {
        TreeSet<INamespace> namespaces = new TreeSet<INamespace>(this.mNamespaces.values());
        StringBuilder sb = new StringBuilder(1000);
        sb.append(CUtilString.LINE_CRLF);
        sb.append("| Namespaces ");
        sb.append(CNodeId.getLocal());
        sb.append("\n");
        sb.append("| NID                           Description                   Targets  Nanos Queues MsgHandled\n");
        for (INamespace ns : namespaces) {
            sb.append("| ");
            sb.append(String.format("%-30.30s", ns.getNID()));
            sb.append(String.format("%-30.30s", ns.getDescription()));
            sb.append(String.format("%7.7s", ns.getTargetRegistry().size()));
            sb.append(String.format("%7.7s", ns.getNanoServiceRegistry().size()));
            sb.append(String.format("%7.7s", ns.getMessageQueueRegistry().size()));
            sb.append(String.format("%11.11s", ns.getMessageCountHandled()));
            sb.append("\n");
        }
        sb.append(CUtilString.LINE_CRLF);
        return sb.toString();
    }
}

