/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.session.verifier;

import de.sillysky.nyssr.address.CNodeAddress;
import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.impl.service.CServiceRegistry;
import de.sillysky.nyssr.impl.session.verifier.CPendingMessageEntry;
import de.sillysky.nyssr.impl.session.verifier.CSessionEntry;
import de.sillysky.nyssr.impl.session.verifier.CUtilSession;
import de.sillysky.nyssr.impl.session.verifier.IDependencies;
import de.sillysky.nyssr.kernel.configuration.IKernelConfiguration;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.login.records.CRecordSessionGetLongToken;
import de.sillysky.nyssr.login.records.CRecordSessionGetPublicKey;
import de.sillysky.nyssr.login.records.CRecordSessionManagementAvailable;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.namespace.IRecordHelper;
import de.sillysky.nyssr.notification.records.CRecordNotifyRemoteNodeRemoved;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.session.verifier.CSessionData;
import de.sillysky.nyssr.session.verifier.ISessionVerifier;
import de.sillysky.nyssr.target.CTarget;
import de.sillysky.nyssr.target.ITarget;
import de.sillysky.nyssr.target.registry.records.CRecordStartTarget;
import de.sillysky.nyssr.util.CByteArrayHashKey;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.prefs.Preferences;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CSessionVerifier
extends CTarget
implements IService,
ISessionVerifier {
    private static final ILogger LOG = CLoggerFactory.getLogger(CSessionVerifier.class);
    public static final IId MICRO_SERVICE_ID_SESSION = CIdFactory.fromObject("ccf168c1-f18b-4229-85f9-24461a19ee6a");
    private final IDependencies mDependencies;
    private PublicKey mPublicKey;
    private CTargetAddress mSessionManagerAddress;
    private final Map<CByteArrayHashKey, CSessionEntry> mTokens = Collections.synchronizedMap(new HashMap());
    private final Map<CByteArrayHashKey, CPendingMessageEntry> mPendingMessages = Collections.synchronizedMap(new HashMap());
    private int mSessionTimeout;

    public CSessionVerifier(@NotNull IDependencies aDependencies) {
        this.mDependencies = aDependencies;
        this.addMessageHandler(CRecordStartTarget.ID, this::asyncStartTarget);
        this.addMessageHandler(CRecordSessionManagementAvailable.ID, this::asyncSessionManagementAvailable);
        this.addMessageHandler(CRecordSessionGetPublicKey.ID, this::asyncSessionGetPublicKey);
        this.addMessageHandler(CRecordSessionGetLongToken.ID, this::asyncSessionGetLongToken);
        this.addMessageHandler(CRecordNotifyRemoteNodeRemoved.ID, this::asyncNotifyRemoteNodeRemoved);
    }

    @Override
    public void activate(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        IId tid = CIdFactory.fromObject("SystemVerifier");
        IKernelConfiguration kc = this.mDependencies.getKernelConfiguration();
        Preferences preferences = kc.getPreferences("session");
        byte[] keyBytes = preferences.getByteArray("public.key.data", null);
        String algorithm = preferences.get("public.key.algorithm", "RSA");
        this.mSessionTimeout = preferences.getInt("timeout.in.minutes", 30);
        if (keyBytes != null) {
            KeyFactory keyFactory = KeyFactory.getInstance(algorithm);
            this.mPublicKey = keyFactory.generatePublic(new X509EncodedKeySpec(keyBytes));
        }
        this.mDependencies.getSystemNamespace().getTargetRegistry().registerTarget(this, tid);
    }

    @Override
    public void deactivate(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        this.deregisterTarget();
    }

    @Override
    public void notifyTargetWillBeRemoved() throws Exception {
        CServiceRegistry.getInstance().deregisterService(this);
        super.notifyTargetWillBeRemoved();
    }

    private boolean asyncStartTarget(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        IRecordHelper rh = this.mDependencies.getRecordHelper();
        rh.addObserver(CRecordNotifyRemoteNodeRemoved.class, this, false);
        rh.addObserver(CRecordSessionManagementAvailable.class, this, true);
        CServiceRegistry.getInstance().registerService(ISessionVerifier.class, this);
        return true;
    }

    private boolean asyncSessionManagementAvailable(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        boolean isAvailable = CRecordSessionManagementAvailable.getIsAvailable(aRecord, false);
        if (isAvailable) {
            this.mSessionManagerAddress = CRecordSessionManagementAvailable.getAddress(aRecord, null);
            LOG.info("SessionManager is available: {}", this.mSessionManagerAddress);
            this.sendGetSessionPublicKey();
        } else {
            this.mSessionManagerAddress = null;
            LOG.info("SessionManager is not available anymore.");
        }
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncSessionGetPublicKey(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws InvalidKeySpecException, NoSuchAlgorithmException {
        if (aEnvelope.isAnswer()) {
            if (aEnvelope.getResultCode() == 0) {
                String keyAlgorithm = CRecordSessionGetPublicKey.getKeyAlgorithm(aRecord, null);
                byte[] keyData = CRecordSessionGetPublicKey.getKeyData(aRecord, null);
                KeyFactory keyFactory = KeyFactory.getInstance(keyAlgorithm);
                this.mPublicKey = keyFactory.generatePublic(new X509EncodedKeySpec(keyData));
                LOG.info("Got public key for verifying session tokens from SessionManager.");
            }
            return true;
        }
        return false;
    }

    private boolean asyncSessionGetLongToken(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            byte[] shortToken = CRecordSessionGetLongToken.getShortToken(aRecord, null);
            CByteArrayHashKey key = new CByteArrayHashKey(shortToken);
            CPendingMessageEntry entry = this.mPendingMessages.remove(key);
            if (entry != null) {
                CEnvelope env = entry.getEnvelope();
                env.setBlocked(false);
                CRecord record = entry.getRecord();
                if (aEnvelope.getResultCode() == 0) {
                    byte[] longToken = CRecordSessionGetLongToken.getLongToken(aRecord, null);
                    env.setSessionToken(longToken);
                    this.getMessageSender().send(env, record);
                    return true;
                }
                LOG.error("Invalid session token for target {}.", entry.getTarget().getName());
                env.setResult(aEnvelope.getResultCode(), aEnvelope.getResultText());
                this.getMessageSender().sendBack(env, record);
            }
            return true;
        }
        return false;
    }

    private boolean asyncNotifyRemoteNodeRemoved(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        if (this.mSessionManagerAddress != null) {
            CNodeAddress nodeAddress = CRecordNotifyRemoteNodeRemoved.getRemoteNode(aRecord, null);
            if (this.mSessionManagerAddress.getNodeAddress().equals(nodeAddress)) {
                this.mSessionManagerAddress = null;
            }
        }
        return true;
    }

    private void sendGetSessionPublicKey() throws CException {
        if (this.mPublicKey == null) {
            CEnvelope env = this.mSessionManagerAddress == null ? CEnvelope.forMicroService(MICRO_SERVICE_ID_SESSION) : CEnvelope.forSingleTarget(this.mSessionManagerAddress);
            CRecord record = CRecordSessionGetPublicKey.create();
            this.sendRequest(env, record);
        }
    }

    private void sendGetSessionToken(byte[] aSessionToken) throws CException {
        CEnvelope env = this.mSessionManagerAddress == null ? CEnvelope.forMicroService(MICRO_SERVICE_ID_SESSION) : CEnvelope.forSingleTarget(this.mSessionManagerAddress);
        CRecord record = CRecordSessionGetLongToken.create();
        CRecordSessionGetLongToken.setShortToken(record, aSessionToken);
        this.sendRequest(env, record);
    }

    @Override
    public CSessionData verifySessionToken(byte[] aSessionToken) {
        if (aSessionToken == null) {
            return null;
        }
        CSessionData sessionData = null;
        if (aSessionToken.length == 16) {
            CByteArrayHashKey key = new CByteArrayHashKey(aSessionToken);
            CSessionEntry entry = this.mTokens.get(key);
            if (entry != null && this.isExpired(entry)) {
                this.mTokens.remove(key);
                return null;
            }
        } else {
            sessionData = CUtilSession.verifyAndDeserializeData(aSessionToken, this.mPublicKey);
            if (sessionData != null) {
                byte[] shortToken = sessionData.getShortToken();
                CByteArrayHashKey key = new CByteArrayHashKey(shortToken);
                CSessionEntry entry = new CSessionEntry(aSessionToken, sessionData);
                this.mTokens.put(key, entry);
            }
        }
        return sessionData;
    }

    @Override
    @Nullable
    public CSessionData verifyRequest(byte[] aToken, @NotNull ITarget aTarget, @NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aToken == null) {
            aEnvelope.setResult(5107, "Missing session token.");
            aEnvelope.setBlocked(false);
            return null;
        }
        if (aToken.length == 16) {
            CByteArrayHashKey key = new CByteArrayHashKey(aToken);
            CSessionEntry entry = this.mTokens.get(key);
            if (entry != null) {
                if (this.isExpired(entry)) {
                    aEnvelope.setSessionToken(null);
                    aEnvelope.setResult(5109, "Session expired.");
                    aEnvelope.setBlocked(false);
                    return null;
                }
                aEnvelope.setSessionToken(entry.getToken());
                aEnvelope.setBlocked(false);
                return entry.getSessionData();
            }
            aEnvelope.setBlocked(true);
            CPendingMessageEntry pending = new CPendingMessageEntry(aToken, aTarget, aEnvelope, aRecord);
            this.mPendingMessages.put(key, pending);
            this.sendGetSessionToken(aToken);
            return null;
        }
        CSessionData sessionData = CUtilSession.verifyAndDeserializeData(aToken, this.mPublicKey);
        if (sessionData == null) {
            aEnvelope.setResult(5108, "Session token unknown.");
            aEnvelope.setBlocked(false);
            return null;
        }
        return sessionData;
    }

    @Override
    public byte[] getLargeSessionToken(byte[] aShortSessionToken) {
        if (aShortSessionToken == null || aShortSessionToken.length != 16) {
            return null;
        }
        CByteArrayHashKey key = new CByteArrayHashKey(aShortSessionToken);
        CSessionEntry entry = this.mTokens.get(key);
        return entry == null ? null : entry.getToken();
    }

    private boolean isExpired(@NotNull CSessionEntry aEntry) {
        return aEntry.getSessionData().getTimeStamp().isBefore(ZonedDateTime.now().minusMinutes(this.mSessionTimeout));
    }
}

