/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.slot;

import de.sillysky.nyssr.slot.CCommonSlotType;
import de.sillysky.nyssr.slot.CSlotType;
import de.sillysky.nyssr.slot.ISingleSlotTypeFactory;
import de.sillysky.nyssr.slot.ISlot;
import de.sillysky.nyssr.util.CUtilChar;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class CSlotChar
implements ISlot,
ISingleSlotTypeFactory {
    @NotNull
    private final Character mValue;

    CSlotChar() {
        this.mValue = Character.valueOf('\u0000');
    }

    private CSlotChar(char aValue) {
        this.mValue = Character.valueOf(aValue);
    }

    @NotNull
    private static CSlotChar fromObject(@Nullable Object aValue) {
        if (aValue instanceof Character) {
            return new CSlotChar(((Character)aValue).charValue());
        }
        if (aValue instanceof String) {
            return CSlotChar.fromString((String)aValue);
        }
        if (aValue instanceof List) {
            return CSlotChar.fromList((List)aValue);
        }
        return new CSlotChar();
    }

    @NotNull
    private static CSlotChar fromList(@NotNull List<?> aValue) {
        CSlotChar result;
        if (aValue.isEmpty()) {
            result = new CSlotChar();
        } else {
            Object object = aValue.get(0);
            result = CSlotChar.fromObject(object);
        }
        return result;
    }

    @NotNull
    private static CSlotChar fromStream(@NotNull DataInput aStream) throws IOException {
        char value = aStream.readChar();
        return new CSlotChar(value);
    }

    @NotNull
    private static CSlotChar fromString(@NotNull String aValue) {
        char value = CUtilChar.fromString(aValue);
        return new CSlotChar(value);
    }

    @Override
    public ISlot fromObject(@NotNull CSlotType aType, @Nullable Object aValue) {
        if (this.getType().equals(aType)) {
            return CSlotChar.fromObject(aValue);
        }
        return null;
    }

    @Override
    @Nullable
    public ISlot fromJson(@Nullable Object aValue, @NotNull Map<Integer, byte[]> aByteArrayStore) {
        if (aValue instanceof String) {
            char c = CUtilChar.fromString((String)aValue);
            return new CSlotChar(c);
        }
        return null;
    }

    @Override
    public boolean equals(@Nullable Object aObj) {
        if (this == aObj) {
            return true;
        }
        if (aObj == null) {
            return false;
        }
        if (this.getClass() != aObj.getClass()) {
            return false;
        }
        CSlotChar other = (CSlotChar)aObj;
        return this.mValue.equals(other.mValue);
    }

    @Override
    @NotNull
    public Class<?> getClassOfProducedObject() {
        return Character.class;
    }

    @Override
    @NotNull
    public ISlot copy() {
        return this;
    }

    @Override
    @NotNull
    public CSlotType getType() {
        return CCommonSlotType.CHAR;
    }

    @Override
    @NotNull
    public Object getValue() {
        return this.mValue;
    }

    @Override
    public int hashCode() {
        return this.mValue.hashCode();
    }

    @Override
    public boolean isContentEqualTo(@Nullable Object aValue) {
        return this.mValue.equals(aValue);
    }

    @Override
    @Nullable
    public ISlot readSlot(@NotNull DataInput aStream, @NotNull CSlotType aType) throws IOException {
        if (this.getType().equals(aType)) {
            return CSlotChar.fromStream(aStream);
        }
        return null;
    }

    @Override
    public void toStream(@NotNull DataOutput aStream) throws IOException {
        aStream.writeChar(this.mValue.charValue());
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public String toString() {
        return Character.toString(this.mValue.charValue());
    }

    @Override
    @Contract(value=" -> new", pure=true)
    @NotNull
    public String valueToString() {
        return Character.toString(this.mValue.charValue());
    }

    @Override
    @Contract(value="_ -> new", pure=true)
    @NotNull
    public Object toJson(@NotNull Map<Integer, byte[]> aBinaries) {
        return CUtilChar.toString(this.mValue.charValue());
    }
}

