/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.slot;

import de.sillysky.nyssr.json.CJsonArray;
import de.sillysky.nyssr.slot.CCommonSlotType;
import de.sillysky.nyssr.slot.CSlotType;
import de.sillysky.nyssr.slot.ISingleSlotTypeFactory;
import de.sillysky.nyssr.slot.ISlot;
import de.sillysky.nyssr.util.CUtilString;
import de.sillysky.nyssr.util.time.CUtilInstant;
import de.sillysky.nyssr.util.time.CUtilInstantArray;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class CSlotInstantArray
implements ISlot,
ISingleSlotTypeFactory {
    @Nullable
    private final Instant[] mValue;

    CSlotInstantArray() {
        this.mValue = null;
    }

    private CSlotInstantArray(@Nullable @Nullable Instant @Nullable [] aValue) {
        this.mValue = aValue == null ? null : Arrays.copyOf(aValue, aValue.length);
    }

    @NotNull
    private static CSlotInstantArray fromObject(@Nullable Object aValue) {
        if (!(aValue instanceof CSlotInstantArray)) {
            Instant[] ii = CUtilInstantArray.fromObject(aValue);
            return new CSlotInstantArray(ii);
        }
        CSlotInstantArray result = (CSlotInstantArray)aValue;
        return result;
    }

    @NotNull
    private static CSlotInstantArray fromList(@NotNull List<?> aValue) {
        Instant[] arr = CUtilInstantArray.fromList(aValue);
        return new CSlotInstantArray(arr);
    }

    @NotNull
    private static CSlotInstantArray fromStream(@NotNull DataInput aStream) throws IOException {
        Instant[] value = CUtilInstantArray.fromStream(aStream);
        return new CSlotInstantArray(value);
    }

    @NotNull
    private static CSlotInstantArray fromString(@NotNull String aValue) {
        Instant[] value = CUtilInstantArray.fromString(aValue);
        return new CSlotInstantArray(value);
    }

    @Override
    @Nullable
    public ISlot fromObject(@NotNull CSlotType aType, @Nullable Object aValue) {
        if (this.getType().equals(aType)) {
            return CSlotInstantArray.fromObject(aValue);
        }
        return null;
    }

    @Override
    @Nullable
    public ISlot fromJson(@Nullable Object aValue, @NotNull Map<Integer, byte[]> aByteArrayStore) {
        if (aValue instanceof CJsonArray) {
            CJsonArray arr = (CJsonArray)aValue;
            Instant[] values = new Instant[arr.size()];
            int i = 0;
            for (Object child : arr.getChildren()) {
                if (child instanceof String && CUtilString.isValid((String)child)) {
                    values[i++] = CUtilInstant.fromIsoString((String)child);
                    continue;
                }
                values[i++] = null;
            }
            return new CSlotInstantArray(values);
        }
        return null;
    }

    @Override
    public boolean equals(@Nullable Object aObj) {
        if (this == aObj) {
            return true;
        }
        if (aObj == null) {
            return false;
        }
        if (this.getClass() != aObj.getClass()) {
            return false;
        }
        CSlotInstantArray other = (CSlotInstantArray)aObj;
        return CUtilInstantArray.isEqual(this.mValue, other.mValue);
    }

    @Override
    @NotNull
    public Class<?> getClassOfProducedObject() {
        return Instant[].class;
    }

    @Override
    public ISlot copy() {
        return new CSlotInstantArray(this.mValue);
    }

    @Override
    @NotNull
    public CSlotType getType() {
        return CCommonSlotType.INSTANT_ARRAY;
    }

    @Override
    @Nullable
    public Object getValue() {
        return this.mValue;
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.mValue);
    }

    @Override
    public boolean isContentEqualTo(@Nullable Object aValue) {
        return Objects.equals(this.mValue, aValue);
    }

    @Override
    @Nullable
    public ISlot readSlot(@NotNull DataInput aStream, @NotNull CSlotType aType) throws IOException {
        if (this.getType().equals(aType)) {
            return CSlotInstantArray.fromStream(aStream);
        }
        return null;
    }

    @Override
    public void toStream(@NotNull DataOutput aStream) throws IOException {
        CUtilInstantArray.toStream(aStream, this.mValue);
    }

    @NotNull
    public String toString() {
        return CUtilInstantArray.toString(this.mValue);
    }

    @Override
    @NotNull
    public String valueToString() {
        return CUtilInstantArray.toString(this.mValue);
    }

    @Override
    @Nullable
    public Object toJson(@NotNull Map<Integer, byte[]> aBinaries) {
        if (this.mValue != null && this.mValue.length > 0) {
            CJsonArray arr = new CJsonArray();
            for (Instant i : this.mValue) {
                arr.add(CUtilInstant.valueToIsoString(i));
            }
            return arr;
        }
        return null;
    }
}

